/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.util.ByteArray;
import com.moilioncircle.redis.replicator.util.Lzf;
import java.io.IOException;

public class BaseRdbParser {
    protected final RedisInputStream in;

    public BaseRdbParser(RedisInputStream in) {
        this.in = in;
    }

    public int rdbLoadTime() throws IOException {
        return this.in.readInt(4);
    }

    public long rdbLoadMillisecondTime() throws IOException {
        return this.in.readLong(8);
    }

    public Len rdbLoadLen() throws IOException {
        long value;
        boolean isencoded = false;
        int rawByte = this.in.read();
        int type = (rawByte & 0xC0) >> 6;
        if (type == 3) {
            isencoded = true;
            value = rawByte & 0x3F;
        } else if (type == 0) {
            value = rawByte & 0x3F;
        } else if (type == 1) {
            value = (rawByte & 0x3F) << 8 | this.in.read();
        } else if (rawByte == 128) {
            value = this.in.readInt(4, false);
        } else if (rawByte == 129) {
            value = this.in.readLong(8, false);
        } else {
            throw new AssertionError((Object)("Un-except len-type:" + type));
        }
        return new Len(value, isencoded);
    }

    public Object rdbLoadIntegerObject(int enctype, int flags) throws IOException {
        byte[] value;
        boolean plain = (flags & 2) != 0;
        boolean encode = (flags & 1) != 0;
        switch (enctype) {
            case 0: {
                value = this.in.readBytes(1L).first();
                break;
            }
            case 1: {
                value = this.in.readBytes(2L).first();
                break;
            }
            case 2: {
                value = this.in.readBytes(4L).first();
                break;
            }
            default: {
                value = new byte[]{0};
            }
        }
        if (plain) {
            return new ByteArray(value);
        }
        if (encode) {
            return new EncodedString(String.valueOf(this.in.readInt(value)), new ByteArray(value));
        }
        return new ByteArray(value);
    }

    public Object rdbLoadLzfStringObject(int flags) throws IOException {
        boolean plain = (flags & 2) != 0;
        boolean encode = (flags & 1) != 0;
        long clen = this.rdbLoadLen().len;
        long len = this.rdbLoadLen().len;
        if (plain) {
            return Lzf.decode(this.in.readBytes(clen), len);
        }
        if (encode) {
            ByteArray bytes = Lzf.decode(this.in.readBytes(clen), len);
            return new EncodedString(new String(bytes.first(), Constants.CHARSET), bytes);
        }
        return Lzf.decode(this.in.readBytes(clen), len);
    }

    public Object rdbGenericLoadStringObject(int flags) throws IOException {
        boolean plain = (flags & 2) != 0;
        boolean encode = (flags & 1) != 0;
        Len lenObj = this.rdbLoadLen();
        long len = (int)lenObj.len;
        boolean isencoded = lenObj.isencoded;
        if (isencoded) {
            switch ((int)len) {
                case 0: 
                case 1: 
                case 2: {
                    return this.rdbLoadIntegerObject((int)len, flags);
                }
                case 3: {
                    return this.rdbLoadLzfStringObject(flags);
                }
            }
            throw new AssertionError((Object)("Unknown RdbParser encoding type:" + len));
        }
        if (plain) {
            return this.in.readBytes(len);
        }
        if (encode) {
            ByteArray bytes = this.in.readBytes(len);
            return new EncodedString(new String(bytes.first(), Constants.CHARSET), bytes);
        }
        return this.in.readBytes(len);
    }

    public ByteArray rdbLoadPlainStringObject() throws IOException {
        return (ByteArray)this.rdbGenericLoadStringObject(2);
    }

    public EncodedString rdbLoadEncodedStringObject() throws IOException {
        return (EncodedString)this.rdbGenericLoadStringObject(1);
    }

    public double rdbLoadDoubleValue() throws IOException {
        int len = this.in.read();
        switch (len) {
            case 255: {
                return Double.NEGATIVE_INFINITY;
            }
            case 254: {
                return Double.POSITIVE_INFINITY;
            }
            case 253: {
                return Double.NaN;
            }
        }
        byte[] bytes = this.in.readBytes(len).first();
        return Double.valueOf(new String(bytes));
    }

    public double rdbLoadBinaryDoubleValue() throws IOException {
        return Double.longBitsToDouble(this.in.readLong(8));
    }

    public static class EncodedString {
        public final String string;
        public final byte[] rawBytes;
        public final ByteArray bytes;

        public EncodedString(String string, ByteArray bytes) {
            this.bytes = bytes;
            this.string = string;
            this.rawBytes = bytes.first();
        }
    }

    public static class LenHelper {
        private LenHelper() {
        }

        public static int zmlen(RedisInputStream in) throws IOException {
            return in.read();
        }

        public static int free(RedisInputStream in) throws IOException {
            return in.read();
        }

        public static int zmElementLen(RedisInputStream in) throws IOException {
            int len = in.read();
            if (len >= 0 && len <= 253) {
                return len;
            }
            if (len == 254) {
                return in.readInt(4, false);
            }
            return len;
        }

        public static int zlbytes(RedisInputStream in) throws IOException {
            return in.readInt(4);
        }

        public static int zlend(RedisInputStream in) throws IOException {
            return in.read();
        }

        public static int zltail(RedisInputStream in) throws IOException {
            return in.readInt(4);
        }

        public static int zllen(RedisInputStream in) throws IOException {
            return in.readInt(2);
        }

        public static int encoding(RedisInputStream in) throws IOException {
            return in.readInt(4);
        }

        public static long lenOfContent(RedisInputStream in) throws IOException {
            return in.readUInt(4);
        }
    }

    public static class StringHelper {
        private StringHelper() {
        }

        public static String str(RedisInputStream in, int len) throws IOException {
            return in.readString(len);
        }

        public static long skip(RedisInputStream in, long len) throws IOException {
            return in.skip(len);
        }

        public static String zipListEntry(RedisInputStream in) throws IOException {
            int prevlen = in.read();
            if (prevlen >= 254) {
                prevlen = in.readInt(4);
            }
            int special = in.read();
            switch (special >> 6) {
                case 0: {
                    int len = special & 0x3F;
                    return StringHelper.str(in, len);
                }
                case 1: {
                    int len = (special & 0x3F) << 8 | in.read();
                    return StringHelper.str(in, len);
                }
                case 2: {
                    int len = in.readInt(4, false);
                    return StringHelper.str(in, len);
                }
            }
            switch (special) {
                case 254: {
                    return String.valueOf(in.readInt(1));
                }
                case 192: {
                    return String.valueOf(in.readInt(2));
                }
                case 240: {
                    return String.valueOf(in.readInt(3));
                }
                case 208: {
                    return String.valueOf(in.readInt(4));
                }
                case 224: {
                    return String.valueOf(in.readLong(8));
                }
            }
            return String.valueOf(special - 241);
        }
    }

    public static class Len {
        public final long len;
        public final boolean isencoded;

        private Len(long len, boolean isencoded) {
            this.len = len;
            this.isencoded = isencoded;
        }
    }
}

