/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb;

import com.moilioncircle.redis.replicator.AbstractReplicator;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.event.PostFullSyncEvent;
import com.moilioncircle.redis.replicator.event.PreFullSyncEvent;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.RdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.DB;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RdbParser {
    protected final RedisInputStream in;
    protected RdbVisitor rdbVisitor;
    protected final AbstractReplicator replicator;
    protected static final Log logger = LogFactory.getLog(RdbParser.class);

    public RdbParser(RedisInputStream in, AbstractReplicator replicator) {
        this.in = in;
        this.replicator = replicator;
        this.rdbVisitor = this.replicator.getRdbVisitor();
    }

    public long parse() throws IOException {
        long checksum;
        this.replicator.submitEvent(new PreFullSyncEvent());
        this.rdbVisitor.applyMagic(this.in);
        int version = this.rdbVisitor.applyVersion(this.in);
        DB db = null;
        block21: while (true) {
            int type = this.rdbVisitor.applyType(this.in);
            Event event = null;
            switch (type) {
                case 253: {
                    event = this.rdbVisitor.applyExpireTime(this.in, db, version);
                    break;
                }
                case 252: {
                    event = this.rdbVisitor.applyExpireTimeMs(this.in, db, version);
                    break;
                }
                case 250: {
                    event = this.rdbVisitor.applyAux(this.in, version);
                    break;
                }
                case 251: {
                    this.rdbVisitor.applyResizeDB(this.in, db, version);
                    break;
                }
                case 254: {
                    db = this.rdbVisitor.applySelectDB(this.in, version);
                    break;
                }
                case 255: {
                    checksum = this.rdbVisitor.applyEof(this.in, version);
                    break block21;
                }
                case 0: {
                    event = this.rdbVisitor.applyString(this.in, db, version);
                    break;
                }
                case 1: {
                    event = this.rdbVisitor.applyList(this.in, db, version);
                    break;
                }
                case 2: {
                    event = this.rdbVisitor.applySet(this.in, db, version);
                    break;
                }
                case 3: {
                    event = this.rdbVisitor.applyZSet(this.in, db, version);
                    break;
                }
                case 5: {
                    event = this.rdbVisitor.applyZSet2(this.in, db, version);
                    break;
                }
                case 4: {
                    event = this.rdbVisitor.applyHash(this.in, db, version);
                    break;
                }
                case 9: {
                    event = this.rdbVisitor.applyHashZipMap(this.in, db, version);
                    break;
                }
                case 10: {
                    event = this.rdbVisitor.applyListZipList(this.in, db, version);
                    break;
                }
                case 11: {
                    event = this.rdbVisitor.applySetIntSet(this.in, db, version);
                    break;
                }
                case 12: {
                    event = this.rdbVisitor.applyZSetZipList(this.in, db, version);
                    break;
                }
                case 13: {
                    event = this.rdbVisitor.applyHashZipList(this.in, db, version);
                    break;
                }
                case 14: {
                    event = this.rdbVisitor.applyListQuickList(this.in, db, version);
                    break;
                }
                case 6: {
                    event = this.rdbVisitor.applyModule(this.in, db, version);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Un-except value-type:" + type + ", please check your ModuleParser"));
                }
            }
            if (event == null) continue;
            if (this.replicator.verbose() && logger.isDebugEnabled()) {
                logger.debug((Object)event);
            }
            this.replicator.submitEvent(event);
        }
        this.replicator.submitEvent(new PostFullSyncEvent(checksum));
        return this.in.total();
    }
}

