/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.module;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.util.ByteArray;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultRdbModuleParser {
    protected static final Log logger = LogFactory.getLog(DefaultRdbModuleParser.class);
    private final RedisInputStream in;
    private final BaseRdbParser parser;

    public DefaultRdbModuleParser(RedisInputStream in) {
        this.in = in;
        this.parser = new BaseRdbParser(in);
    }

    public RedisInputStream inputStream() {
        return this.in;
    }

    public long loadSigned() throws IOException {
        return this.parser.rdbLoadLen().len;
    }

    public long loadUnSigned() throws IOException {
        logger.warn((Object)"Un-support [loadUnSigned]. using [loadSigned] instead");
        return this.loadSigned();
    }

    public String loadString() throws IOException {
        ByteArray bytes = (ByteArray)this.parser.rdbGenericLoadStringObject(0);
        return new String(bytes.first(), Constants.CHARSET);
    }

    public String loadStringBuffer() throws IOException {
        ByteArray bytes = (ByteArray)this.parser.rdbGenericLoadStringObject(2);
        return new String(bytes.first(), Constants.CHARSET);
    }

    public double loadDouble() throws IOException {
        return this.parser.rdbLoadBinaryDoubleValue();
    }
}

