/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import java.util.Iterator;

public class ByteArray
implements Iterable<byte[]> {
    protected static final int BITS = 30;
    protected static final int MAGIC = 0x40000000;
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 2305843007066210304L;
    protected final int cap;
    protected final long length;
    protected byte[] smallBytes;
    protected byte[][] largeBytes;

    public ByteArray(byte[] smallBytes) {
        this(smallBytes, Integer.MAX_VALUE);
    }

    public ByteArray(long length) {
        this(length, Integer.MAX_VALUE);
    }

    public ByteArray(byte[] smallBytes, int cap) {
        this.cap = cap;
        this.length = smallBytes.length;
        this.smallBytes = smallBytes;
    }

    public ByteArray(long length, int cap) {
        this.cap = cap;
        this.length = length;
        if (length > 2305843007066210304L || length < 0L) {
            throw new IllegalArgumentException(String.valueOf(length));
        }
        if (length <= (long)cap) {
            this.smallBytes = new byte[(int)length];
        } else {
            int x = (int)(length >> 30);
            int y = (int)(length & 0x3FFFFFFFL);
            this.largeBytes = new byte[x + 1][];
            for (int i = 0; i < this.largeBytes.length; ++i) {
                this.largeBytes[i] = i == this.largeBytes.length - 1 ? new byte[y] : new byte[0x40000000];
            }
        }
    }

    public void set(long idx, byte value) {
        if (this.smallBytes != null) {
            this.smallBytes[(int)idx] = value;
            return;
        }
        int x = (int)(idx >> 30);
        int y = (int)(idx & 0x3FFFFFFFL);
        this.largeBytes[x][y] = value;
    }

    public byte get(long idx) {
        if (this.smallBytes != null) {
            return this.smallBytes[(int)idx];
        }
        int x = (int)(idx >> 30);
        int y = (int)(idx & 0x3FFFFFFFL);
        return this.largeBytes[x][y];
    }

    public long length() {
        return this.length;
    }

    public byte[] first() {
        Iterator<byte[]> it = this.iterator();
        return it.hasNext() ? it.next() : null;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iter();
    }

    public static void arraycopy(ByteArray src, long srcPos, ByteArray dest, long destPos, long length) {
        if (srcPos + length > src.length || destPos + length > dest.length) {
            throw new IndexOutOfBoundsException();
        }
        if (srcPos + length <= (long)src.cap && destPos + length <= (long)dest.cap) {
            System.arraycopy(src.smallBytes, (int)srcPos, dest.smallBytes, (int)destPos, (int)length);
            return;
        }
        while (length > 0L) {
            int x1 = (int)(srcPos >> 30);
            int y1 = (int)(srcPos & 0x3FFFFFFFL);
            int x2 = (int)(destPos >> 30);
            int y2 = (int)(destPos & 0x3FFFFFFFL);
            int min = Math.min(0x40000000 - y1, 0x40000000 - y2);
            if (length <= 0x40000000L) {
                min = Math.min(min, (int)length);
            }
            System.arraycopy(src.largeBytes[x1], y1, dest.largeBytes[x2], y2, min);
            srcPos += (long)min;
            destPos += (long)min;
            length -= (long)min;
        }
        assert (length == 0L);
    }

    protected class Iter
    implements Iterator<byte[]> {
        protected int index = 0;

        protected Iter() {
        }

        @Override
        public boolean hasNext() {
            if (ByteArray.this.smallBytes != null) {
                return this.index < 1;
            }
            return this.index < ByteArray.this.largeBytes.length;
        }

        @Override
        public byte[] next() {
            if (ByteArray.this.smallBytes != null) {
                ++this.index;
                return ByteArray.this.smallBytes;
            }
            return ByteArray.this.largeBytes[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

