/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import com.moilioncircle.redis.replicator.Constants;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ByteBuilder {
    private final ByteBuffer buffer;
    private final List<byte[]> list = new ArrayList<byte[]>();
    private int total = 0;

    private ByteBuilder(int cap) {
        this.buffer = ByteBuffer.allocate(cap);
    }

    public static ByteBuilder allocate(int cap) {
        return new ByteBuilder(cap);
    }

    public void put(byte b) {
        ++this.total;
        if (this.buffer.hasRemaining()) {
            this.buffer.put(b);
        } else {
            byte[] temp = new byte[this.buffer.capacity()];
            System.arraycopy(this.buffer.array(), 0, temp, 0, this.buffer.capacity());
            this.list.add(temp);
            this.buffer.clear();
            this.buffer.put(b);
        }
    }

    public int length() {
        return this.total;
    }

    public byte[] array() {
        int len = this.total;
        if (len < this.buffer.capacity()) {
            return this.buffer.array();
        }
        int offset = 0;
        byte[] ary = new byte[len];
        for (byte[] ba : this.list) {
            System.arraycopy(ba, 0, ary, offset, ba.length);
            offset += ba.length;
            len -= ba.length;
        }
        if (len > 0) {
            System.arraycopy(this.buffer.array(), 0, ary, offset, len);
        }
        return ary;
    }

    public String toString() {
        return new String(this.array(), 0, this.total, Constants.CHARSET);
    }
}

