/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.io;

import com.moilioncircle.redis.replicator.util.CRC64;
import java.io.IOException;
import java.io.OutputStream;

public class CRCOutputStream
extends OutputStream {
    private long checksum = 0L;
    private final OutputStream out;

    public CRCOutputStream(OutputStream out) {
        this.out = out;
    }

    public byte[] getCRC64() {
        return CRC64.longToByteArray(this.checksum);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.checksum = CRC64.crc64(new byte[]{(byte)b}, this.checksum);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.checksum = CRC64.crc64(b, off, len, this.checksum);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

