/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.iterable;

import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.event.EventListener;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueModule;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueStream;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueString;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.datatype.Stream;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.BatchedKeyStringValueHash;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.BatchedKeyStringValueList;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.BatchedKeyStringValueModule;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.BatchedKeyStringValueSet;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.BatchedKeyStringValueStream;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.BatchedKeyStringValueString;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.BatchedKeyStringValueZSet;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueByteArrayIterator;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueMapEntryIterator;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueZSetEntryIterator;
import com.moilioncircle.redis.replicator.util.ByteArrayList;
import com.moilioncircle.redis.replicator.util.ByteArrayMap;
import com.moilioncircle.redis.replicator.util.ByteArraySet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValueIterableEventListener
implements EventListener {
    private final int batchSize;
    private final boolean order;
    private final EventListener listener;

    public ValueIterableEventListener(EventListener listener) {
        this(64, listener);
    }

    public ValueIterableEventListener(int batchSize, EventListener listener) {
        this(true, batchSize, listener);
    }

    public ValueIterableEventListener(boolean order, int batchSize, EventListener listener) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException(String.valueOf(batchSize));
        }
        this.order = order;
        this.batchSize = batchSize;
        this.listener = listener;
    }

    @Override
    public void onEvent(Replicator replicator, Event event) {
        if (!(event instanceof KeyValuePair)) {
            this.listener.onEvent(replicator, event);
            return;
        }
        KeyValuePair kv = (KeyValuePair)event;
        int batch = 0;
        int type = kv.getValueRdbType();
        if (kv instanceof KeyStringValueString) {
            KeyStringValueString ksvs = (KeyStringValueString)kv;
            this.listener.onEvent(replicator, this.string(ksvs, (byte[])ksvs.getValue(), batch, true));
        } else if (kv instanceof KeyStringValueByteArrayIterator) {
            if (type == 2 || type == 11) {
                KeyStringValueByteArrayIterator skv = (KeyStringValueByteArrayIterator)kv;
                Iterator it = (Iterator)skv.getValue();
                ByteArraySet prev = null;
                Set<byte[]> next = new ByteArraySet(this.order, this.batchSize);
                while (it.hasNext()) {
                    next.add((byte[])it.next());
                    if (next.size() != this.batchSize) continue;
                    if (prev != null) {
                        this.listener.onEvent(replicator, this.set(skv, prev, batch++, false));
                    }
                    prev = next;
                    next = this.create(this.order, this.batchSize);
                }
                boolean last = next.isEmpty();
                this.listener.onEvent(replicator, this.set(skv, prev, batch++, last));
                if (!last) {
                    this.listener.onEvent(replicator, this.set(skv, next, batch++, true));
                }
            } else {
                KeyStringValueByteArrayIterator lkv = (KeyStringValueByteArrayIterator)kv;
                Iterator it = (Iterator)lkv.getValue();
                ByteArrayList prev = null;
                ByteArrayList next = new ByteArrayList(this.batchSize);
                while (it.hasNext()) {
                    try {
                        next.add(it.next());
                        if (next.size() != this.batchSize) continue;
                        if (prev != null) {
                            this.listener.onEvent(replicator, this.list(lkv, prev, batch++, false));
                        }
                        prev = next;
                        next = new ByteArrayList(this.batchSize);
                    }
                    catch (IllegalStateException last) {}
                }
                boolean last = next.isEmpty();
                this.listener.onEvent(replicator, this.list(lkv, prev, batch++, last));
                if (!last) {
                    this.listener.onEvent(replicator, this.list(lkv, next, batch++, true));
                }
            }
        } else if (kv instanceof KeyStringValueMapEntryIterator) {
            KeyStringValueMapEntryIterator mkv = (KeyStringValueMapEntryIterator)kv;
            Iterator it = (Iterator)mkv.getValue();
            ByteArrayMap prev = null;
            ByteArrayMap next = new ByteArrayMap(this.order, this.batchSize);
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                next.put(entry.getKey(), entry.getValue());
                if (next.size() != this.batchSize) continue;
                if (prev != null) {
                    this.listener.onEvent(replicator, this.hash(mkv, prev, batch++, false));
                }
                prev = next;
                next = new ByteArrayMap(this.order, this.batchSize);
            }
            boolean last = next.isEmpty();
            this.listener.onEvent(replicator, this.hash(mkv, prev, batch++, last));
            if (!last) {
                this.listener.onEvent(replicator, this.hash(mkv, next, batch++, true));
            }
        } else if (kv instanceof KeyStringValueZSetEntryIterator) {
            KeyStringValueZSetEntryIterator zkv = (KeyStringValueZSetEntryIterator)kv;
            Iterator it = (Iterator)zkv.getValue();
            Set<ZSetEntry> prev = null;
            Set<ZSetEntry> next = this.create(this.order, this.batchSize);
            while (it.hasNext()) {
                next.add((ZSetEntry)it.next());
                if (next.size() != this.batchSize) continue;
                if (prev != null) {
                    this.listener.onEvent(replicator, this.zset(zkv, prev, batch++, false));
                }
                prev = next;
                next = this.create(this.order, this.batchSize);
            }
            boolean last = next.isEmpty();
            this.listener.onEvent(replicator, this.zset(zkv, prev, batch++, last));
            if (!last) {
                this.listener.onEvent(replicator, this.zset(zkv, next, batch++, true));
            }
        } else if (kv instanceof KeyStringValueModule) {
            this.listener.onEvent(replicator, this.module((KeyStringValueModule)kv, (Module)kv.getValue(), batch, true));
        } else if (kv instanceof KeyStringValueStream) {
            this.listener.onEvent(replicator, this.stream((KeyStringValueStream)kv, (Stream)kv.getValue(), batch, true));
        }
    }

    private <T> Set<T> create(boolean order, int batchSize) {
        return order ? new LinkedHashSet(batchSize) : new HashSet(batchSize);
    }

    private BatchedKeyStringValueString string(KeyValuePair<byte[], ?> raw, byte[] value, int batch, boolean last) {
        BatchedKeyStringValueString kv = new BatchedKeyStringValueString();
        kv.setDb(raw.getDb());
        kv.setExpiredType(raw.getExpiredType());
        kv.setExpiredValue(raw.getExpiredValue());
        kv.setEvictType(raw.getEvictType());
        kv.setEvictValue(raw.getEvictValue());
        kv.setValueRdbType(raw.getValueRdbType());
        kv.setKey(raw.getKey());
        kv.setValue(value);
        kv.setBatch(batch);
        kv.setLast(last);
        return kv;
    }

    private BatchedKeyStringValueModule module(KeyValuePair<byte[], ?> raw, Module value, int batch, boolean last) {
        BatchedKeyStringValueModule kv = new BatchedKeyStringValueModule();
        kv.setDb(raw.getDb());
        kv.setExpiredType(raw.getExpiredType());
        kv.setExpiredValue(raw.getExpiredValue());
        kv.setEvictType(raw.getEvictType());
        kv.setEvictValue(raw.getEvictValue());
        kv.setValueRdbType(raw.getValueRdbType());
        kv.setKey(raw.getKey());
        kv.setValue(value);
        kv.setBatch(batch);
        kv.setLast(last);
        return kv;
    }

    private BatchedKeyStringValueHash hash(KeyValuePair<byte[], ?> raw, Map<byte[], byte[]> value, int batch, boolean last) {
        BatchedKeyStringValueHash kv = new BatchedKeyStringValueHash();
        kv.setDb(raw.getDb());
        kv.setExpiredType(raw.getExpiredType());
        kv.setExpiredValue(raw.getExpiredValue());
        kv.setEvictType(raw.getEvictType());
        kv.setEvictValue(raw.getEvictValue());
        kv.setValueRdbType(raw.getValueRdbType());
        kv.setKey(raw.getKey());
        kv.setValue(value);
        kv.setBatch(batch);
        kv.setLast(last);
        return kv;
    }

    private BatchedKeyStringValueList list(KeyValuePair<byte[], ?> raw, List<byte[]> value, int batch, boolean last) {
        BatchedKeyStringValueList kv = new BatchedKeyStringValueList();
        kv.setDb(raw.getDb());
        kv.setExpiredType(raw.getExpiredType());
        kv.setExpiredValue(raw.getExpiredValue());
        kv.setEvictType(raw.getEvictType());
        kv.setEvictValue(raw.getEvictValue());
        kv.setValueRdbType(raw.getValueRdbType());
        kv.setKey(raw.getKey());
        kv.setValue(value);
        kv.setBatch(batch);
        kv.setLast(last);
        return kv;
    }

    private BatchedKeyStringValueSet set(KeyValuePair<byte[], ?> raw, Set<byte[]> value, int batch, boolean last) {
        BatchedKeyStringValueSet kv = new BatchedKeyStringValueSet();
        kv.setDb(raw.getDb());
        kv.setExpiredType(raw.getExpiredType());
        kv.setExpiredValue(raw.getExpiredValue());
        kv.setEvictType(raw.getEvictType());
        kv.setEvictValue(raw.getEvictValue());
        kv.setValueRdbType(raw.getValueRdbType());
        kv.setKey(raw.getKey());
        kv.setValue(value);
        kv.setBatch(batch);
        kv.setLast(last);
        return kv;
    }

    private BatchedKeyStringValueZSet zset(KeyValuePair<byte[], ?> raw, Set<ZSetEntry> value, int batch, boolean last) {
        BatchedKeyStringValueZSet kv = new BatchedKeyStringValueZSet();
        kv.setDb(raw.getDb());
        kv.setExpiredType(raw.getExpiredType());
        kv.setExpiredValue(raw.getExpiredValue());
        kv.setEvictType(raw.getEvictType());
        kv.setEvictValue(raw.getEvictValue());
        kv.setValueRdbType(raw.getValueRdbType());
        kv.setKey(raw.getKey());
        kv.setValue(value);
        kv.setBatch(batch);
        kv.setLast(last);
        return kv;
    }

    private BatchedKeyStringValueStream stream(KeyValuePair<byte[], ?> raw, Stream value, int batch, boolean last) {
        BatchedKeyStringValueStream kv = new BatchedKeyStringValueStream();
        kv.setDb(raw.getDb());
        kv.setExpiredType(raw.getExpiredType());
        kv.setExpiredValue(raw.getExpiredValue());
        kv.setEvictType(raw.getEvictType());
        kv.setEvictValue(raw.getEvictValue());
        kv.setValueRdbType(raw.getValueRdbType());
        kv.setKey(raw.getKey());
        kv.setValue(value);
        kv.setBatch(batch);
        kv.setLast(last);
        return kv;
    }
}

