package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.TeamAddMemberFailure;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

import java.io.Serializable;
/**
 * TeamMemberAddListingResponse
 */

public class TeamMemberAddListingResponse  implements Serializable {
  
  private List<UserReference> entities = new ArrayList<UserReference>();
  private List<TeamAddMemberFailure> failures = new ArrayList<TeamAddMemberFailure>();

  
  /**
   **/
  public TeamMemberAddListingResponse entities(List<UserReference> entities) {
    this.entities = entities;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("entities")
  public List<UserReference> getEntities() {
    return entities;
  }
  public void setEntities(List<UserReference> entities) {
    this.entities = entities;
  }


  @ApiModelProperty(example = "null", value = "List of any user ids that were not added.")
  @JsonProperty("failures")
  public List<TeamAddMemberFailure> getFailures() {
    return failures;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TeamMemberAddListingResponse teamMemberAddListingResponse = (TeamMemberAddListingResponse) o;

    return Objects.equals(this.entities, teamMemberAddListingResponse.entities) &&
            Objects.equals(this.failures, teamMemberAddListingResponse.failures);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entities, failures);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TeamMemberAddListingResponse {\n");
    
    sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
    sb.append("    failures: ").append(toIndentedString(failures)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

