/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2;

import com.mypurecloud.sdk.v2.ApiResponse;
import java.util.Collections;
import java.util.Map;

public class ApiException
extends Exception
implements ApiResponse<Object> {
    private final int statusCode;
    private final Map<String, String> headers;
    private final String body;

    public ApiException(int statusCode, String message, Map<String, String> headers, String body) {
        super(message);
        this.statusCode = statusCode;
        this.headers = Collections.unmodifiableMap(headers);
        this.body = body;
    }

    public ApiException(Throwable cause) {
        super(cause);
        this.statusCode = -1;
        this.headers = Collections.emptyMap();
        this.body = null;
    }

    @Override
    public Exception getException() {
        return this;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusReasonPhrase() {
        return this.getMessage();
    }

    @Override
    public boolean hasRawBody() {
        return this.body != null && !this.body.isEmpty();
    }

    @Override
    public String getRawBody() {
        return this.body;
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String key) {
        return this.headers.get(key);
    }

    @Override
    public String getCorrelationId() {
        return this.getHeader("ININ-Correlation-Id");
    }

    @Override
    public void close() throws Exception {
    }
}

