package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.model.*;
import com.mypurecloud.sdk.v2.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import com.mypurecloud.sdk.v2.model.DataSchema;
import com.mypurecloud.sdk.v2.model.DataSchemaListing;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.Workbin;
import com.mypurecloud.sdk.v2.model.WorkbinChangeListing;
import com.mypurecloud.sdk.v2.model.WorkbinCreate;
import com.mypurecloud.sdk.v2.model.WorkbinQueryEntityListing;
import com.mypurecloud.sdk.v2.model.WorkbinQueryRequest;
import com.mypurecloud.sdk.v2.model.WorkbinUpdate;
import com.mypurecloud.sdk.v2.model.WorkbinVersion;
import com.mypurecloud.sdk.v2.model.WorkbinVersionListing;
import com.mypurecloud.sdk.v2.model.Workitem;
import com.mypurecloud.sdk.v2.model.WorkitemChangeListing;
import com.mypurecloud.sdk.v2.model.WorkitemCreate;
import com.mypurecloud.sdk.v2.model.WorkitemManualAssign;
import com.mypurecloud.sdk.v2.model.WorkitemPagedEntityListing;
import com.mypurecloud.sdk.v2.model.WorkitemPostQueryEntityListing;
import com.mypurecloud.sdk.v2.model.WorkitemQueryJobCreate;
import com.mypurecloud.sdk.v2.model.WorkitemQueryJobResponse;
import com.mypurecloud.sdk.v2.model.WorkitemQueryPostRequest;
import com.mypurecloud.sdk.v2.model.WorkitemStatus;
import com.mypurecloud.sdk.v2.model.WorkitemStatusCreate;
import com.mypurecloud.sdk.v2.model.WorkitemStatusListing;
import com.mypurecloud.sdk.v2.model.WorkitemStatusUpdate;
import com.mypurecloud.sdk.v2.model.WorkitemTerminate;
import com.mypurecloud.sdk.v2.model.WorkitemUpdate;
import com.mypurecloud.sdk.v2.model.WorkitemVersion;
import com.mypurecloud.sdk.v2.model.WorkitemVersionListing;
import com.mypurecloud.sdk.v2.model.WorkitemWrapup;
import com.mypurecloud.sdk.v2.model.WorkitemWrapupEntityListing;
import com.mypurecloud.sdk.v2.model.WorkitemWrapupUpdate;
import com.mypurecloud.sdk.v2.model.Worktype;
import com.mypurecloud.sdk.v2.model.WorktypeChangeListing;
import com.mypurecloud.sdk.v2.model.WorktypeCreate;
import com.mypurecloud.sdk.v2.model.WorktypeQueryEntityListing;
import com.mypurecloud.sdk.v2.model.WorktypeQueryRequest;
import com.mypurecloud.sdk.v2.model.WorktypeUpdate;
import com.mypurecloud.sdk.v2.model.WorktypeVersion;
import com.mypurecloud.sdk.v2.model.WorktypeVersionListing;

public class GetTaskmanagementWorkbinVersionRequest {

	private String workbinId;
	public String getWorkbinId() {
		return this.workbinId;
	}

	public void setWorkbinId(String workbinId) {
		this.workbinId = workbinId;
	}

	public GetTaskmanagementWorkbinVersionRequest withWorkbinId(String workbinId) {
	    this.setWorkbinId(workbinId);
	    return this;
	} 

	private Integer entityVersion;
	public Integer getEntityVersion() {
		return this.entityVersion;
	}

	public void setEntityVersion(Integer entityVersion) {
		this.entityVersion = entityVersion;
	}

	public GetTaskmanagementWorkbinVersionRequest withEntityVersion(Integer entityVersion) {
	    this.setEntityVersion(entityVersion);
	    return this;
	} 

	private final Map<String, String> customHeaders = new HashMap<>();
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetTaskmanagementWorkbinVersionRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        
        // verify the required parameter 'workbinId' is set
        if (this.workbinId == null) {
            throw new IllegalStateException("Missing the required parameter 'workbinId' when building request for GetTaskmanagementWorkbinVersionRequest.");
        }
        
        // verify the required parameter 'entityVersion' is set
        if (this.entityVersion == null) {
            throw new IllegalStateException("Missing the required parameter 'entityVersion' when building request for GetTaskmanagementWorkbinVersionRequest.");
        }
        

        return ApiRequestBuilder.create("GET", "/api/v2/taskmanagement/workbins/{workbinId}/versions/{entityVersion}")
                .withPathParameter("workbinId", workbinId)
        
                .withPathParameter("entityVersion", entityVersion)
        
		.withCustomHeaders(customHeaders)
                .withContentTypes("application/json")
                .withAccepts("application/json")
                .withAuthNames("PureCloud OAuth")
                .build();
    }

	public static Builder builder() {
		return new Builder();
	}


	public static Builder builder(String workbinId, Integer entityVersion) {
	    return new Builder()
	            .withRequiredParams(workbinId, entityVersion);
	}


	public static class Builder {
		private final GetTaskmanagementWorkbinVersionRequest request;

		private Builder() {
			request = new GetTaskmanagementWorkbinVersionRequest();
		}


		public Builder withWorkbinId(String workbinId) {
			request.setWorkbinId(workbinId);
			return this;
		}

		public Builder withEntityVersion(Integer entityVersion) {
			request.setEntityVersion(entityVersion);
			return this;
		}



		public Builder withRequiredParams(String workbinId, Integer entityVersion) {
			request.setWorkbinId(workbinId);
			request.setEntityVersion(entityVersion);

			return this;
		}


		public GetTaskmanagementWorkbinVersionRequest build() {
            
            // verify the required parameter 'workbinId' is set
            if (request.workbinId == null) {
                throw new IllegalStateException("Missing the required parameter 'workbinId' when building request for GetTaskmanagementWorkbinVersionRequest.");
            }
            
            // verify the required parameter 'entityVersion' is set
            if (request.entityVersion == null) {
                throw new IllegalStateException("Missing the required parameter 'entityVersion' when building request for GetTaskmanagementWorkbinVersionRequest.");
            }
            
			return request;
		}
	}
}
