package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.model.*;
import com.mypurecloud.sdk.v2.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import com.mypurecloud.sdk.v2.model.ClonedUser;
import com.mypurecloud.sdk.v2.model.ClonedUserEntityListing;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.RoleDivisionGrants;
import com.mypurecloud.sdk.v2.model.TrustCreate;
import com.mypurecloud.sdk.v2.model.TrustEntityListing;
import com.mypurecloud.sdk.v2.model.TrustGroup;
import com.mypurecloud.sdk.v2.model.TrustGroupEntityListing;
import com.mypurecloud.sdk.v2.model.TrustMemberCreate;
import com.mypurecloud.sdk.v2.model.TrustRequest;
import com.mypurecloud.sdk.v2.model.TrustRequestCreate;
import com.mypurecloud.sdk.v2.model.TrustUpdate;
import com.mypurecloud.sdk.v2.model.TrustUser;
import com.mypurecloud.sdk.v2.model.TrustUserEntityListing;
import com.mypurecloud.sdk.v2.model.Trustee;
import com.mypurecloud.sdk.v2.model.TrusteeAuditQueryRequest;
import com.mypurecloud.sdk.v2.model.Trustor;
import com.mypurecloud.sdk.v2.model.TrustorAuditQueryRequest;
import com.mypurecloud.sdk.v2.model.TrustorEntityListing;
import com.mypurecloud.sdk.v2.model.UserAuthorization;

public class PutOrgauthorizationTrusteeGroupRoledivisionsRequest {

	private String trusteeOrgId;
	public String getTrusteeOrgId() {
		return this.trusteeOrgId;
	}

	public void setTrusteeOrgId(String trusteeOrgId) {
		this.trusteeOrgId = trusteeOrgId;
	}

	public PutOrgauthorizationTrusteeGroupRoledivisionsRequest withTrusteeOrgId(String trusteeOrgId) {
	    this.setTrusteeOrgId(trusteeOrgId);
	    return this;
	} 

	private String trusteeGroupId;
	public String getTrusteeGroupId() {
		return this.trusteeGroupId;
	}

	public void setTrusteeGroupId(String trusteeGroupId) {
		this.trusteeGroupId = trusteeGroupId;
	}

	public PutOrgauthorizationTrusteeGroupRoledivisionsRequest withTrusteeGroupId(String trusteeGroupId) {
	    this.setTrusteeGroupId(trusteeGroupId);
	    return this;
	} 

	private RoleDivisionGrants body;
	public RoleDivisionGrants getBody() {
		return this.body;
	}

	public void setBody(RoleDivisionGrants body) {
		this.body = body;
	}

	public PutOrgauthorizationTrusteeGroupRoledivisionsRequest withBody(RoleDivisionGrants body) {
	    this.setBody(body);
	    return this;
	} 

	private final Map<String, String> customHeaders = new HashMap<>();
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutOrgauthorizationTrusteeGroupRoledivisionsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<RoleDivisionGrants> withHttpInfo() {
        
        // verify the required parameter 'trusteeOrgId' is set
        if (this.trusteeOrgId == null) {
            throw new IllegalStateException("Missing the required parameter 'trusteeOrgId' when building request for PutOrgauthorizationTrusteeGroupRoledivisionsRequest.");
        }
        
        // verify the required parameter 'trusteeGroupId' is set
        if (this.trusteeGroupId == null) {
            throw new IllegalStateException("Missing the required parameter 'trusteeGroupId' when building request for PutOrgauthorizationTrusteeGroupRoledivisionsRequest.");
        }
        
        // verify the required parameter 'body' is set
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutOrgauthorizationTrusteeGroupRoledivisionsRequest.");
        }
        

        return ApiRequestBuilder.create("PUT", "/api/v2/orgauthorization/trustees/{trusteeOrgId}/groups/{trusteeGroupId}/roledivisions")
                .withPathParameter("trusteeOrgId", trusteeOrgId)
        
                .withPathParameter("trusteeGroupId", trusteeGroupId)
        
                .withBody(body)

		.withCustomHeaders(customHeaders)
                .withContentTypes("application/json")
                .withAccepts("application/json")
                .withAuthNames("PureCloud OAuth")
                .build();
    }

	public static Builder builder() {
		return new Builder();
	}


	public static Builder builder(String trusteeOrgId, String trusteeGroupId, RoleDivisionGrants body) {
	    return new Builder()
	            .withRequiredParams(trusteeOrgId, trusteeGroupId, body);
	}


	public static class Builder {
		private final PutOrgauthorizationTrusteeGroupRoledivisionsRequest request;

		private Builder() {
			request = new PutOrgauthorizationTrusteeGroupRoledivisionsRequest();
		}


		public Builder withTrusteeOrgId(String trusteeOrgId) {
			request.setTrusteeOrgId(trusteeOrgId);
			return this;
		}

		public Builder withTrusteeGroupId(String trusteeGroupId) {
			request.setTrusteeGroupId(trusteeGroupId);
			return this;
		}

		public Builder withBody(RoleDivisionGrants body) {
			request.setBody(body);
			return this;
		}



		public Builder withRequiredParams(String trusteeOrgId, String trusteeGroupId, RoleDivisionGrants body) {
			request.setTrusteeOrgId(trusteeOrgId);
			request.setTrusteeGroupId(trusteeGroupId);
			request.setBody(body);

			return this;
		}


		public PutOrgauthorizationTrusteeGroupRoledivisionsRequest build() {
            
            // verify the required parameter 'trusteeOrgId' is set
            if (request.trusteeOrgId == null) {
                throw new IllegalStateException("Missing the required parameter 'trusteeOrgId' when building request for PutOrgauthorizationTrusteeGroupRoledivisionsRequest.");
            }
            
            // verify the required parameter 'trusteeGroupId' is set
            if (request.trusteeGroupId == null) {
                throw new IllegalStateException("Missing the required parameter 'trusteeGroupId' when building request for PutOrgauthorizationTrusteeGroupRoledivisionsRequest.");
            }
            
            // verify the required parameter 'body' is set
            if (request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutOrgauthorizationTrusteeGroupRoledivisionsRequest.");
            }
            
			return request;
		}
	}
}
