package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
/**
 * Browser
 */

public class Browser  implements Serializable {
  
  private String family = null;
  private String version = null;
  private String lang = null;
  private String fingerprint = null;
  private Boolean isMobile = null;
  private Integer viewHeight = null;
  private Integer viewWidth = null;
  private Boolean featuresFlash = null;
  private Boolean featuresJava = null;
  private Boolean featuresPdf = null;
  private Boolean featuresWebrtc = null;

  
  /**
   * Browser family (e.g. Chrome, Safari, Firefox).
   **/
  public Browser family(String family) {
    this.family = family;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Browser family (e.g. Chrome, Safari, Firefox).")
  @JsonProperty("family")
  public String getFamily() {
    return family;
  }
  public void setFamily(String family) {
    this.family = family;
  }


  /**
   * Browser version (e.g. 68.0.3440.84).
   **/
  public Browser version(String version) {
    this.version = version;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Browser version (e.g. 68.0.3440.84).")
  @JsonProperty("version")
  public String getVersion() {
    return version;
  }
  public void setVersion(String version) {
    this.version = version;
  }


  /**
   * Language the browser is set to. Must conform to BCP 47.
   **/
  public Browser lang(String lang) {
    this.lang = lang;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Language the browser is set to. Must conform to BCP 47.")
  @JsonProperty("lang")
  public String getLang() {
    return lang;
  }
  public void setLang(String lang) {
    this.lang = lang;
  }


  /**
   * Fingerprint generated by looking at the individual browser features.
   **/
  public Browser fingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Fingerprint generated by looking at the individual browser features.")
  @JsonProperty("fingerprint")
  public String getFingerprint() {
    return fingerprint;
  }
  public void setFingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
  }


  /**
   * Flag that is true for mobile devices.
   **/
  public Browser isMobile(Boolean isMobile) {
    this.isMobile = isMobile;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Flag that is true for mobile devices.")
  @JsonProperty("isMobile")
  public Boolean getIsMobile() {
    return isMobile;
  }
  public void setIsMobile(Boolean isMobile) {
    this.isMobile = isMobile;
  }


  /**
   * Browser's viewport height.
   **/
  public Browser viewHeight(Integer viewHeight) {
    this.viewHeight = viewHeight;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Browser's viewport height.")
  @JsonProperty("viewHeight")
  public Integer getViewHeight() {
    return viewHeight;
  }
  public void setViewHeight(Integer viewHeight) {
    this.viewHeight = viewHeight;
  }


  /**
   * Browser's viewport width.
   **/
  public Browser viewWidth(Integer viewWidth) {
    this.viewWidth = viewWidth;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Browser's viewport width.")
  @JsonProperty("viewWidth")
  public Integer getViewWidth() {
    return viewWidth;
  }
  public void setViewWidth(Integer viewWidth) {
    this.viewWidth = viewWidth;
  }


  /**
   * Whether Flash is installed.
   **/
  public Browser featuresFlash(Boolean featuresFlash) {
    this.featuresFlash = featuresFlash;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Whether Flash is installed.")
  @JsonProperty("featuresFlash")
  public Boolean getFeaturesFlash() {
    return featuresFlash;
  }
  public void setFeaturesFlash(Boolean featuresFlash) {
    this.featuresFlash = featuresFlash;
  }


  /**
   * Whether Java is installed.
   **/
  public Browser featuresJava(Boolean featuresJava) {
    this.featuresJava = featuresJava;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Whether Java is installed.")
  @JsonProperty("featuresJava")
  public Boolean getFeaturesJava() {
    return featuresJava;
  }
  public void setFeaturesJava(Boolean featuresJava) {
    this.featuresJava = featuresJava;
  }


  /**
   * Whether the browser recognizes PDFs.
   **/
  public Browser featuresPdf(Boolean featuresPdf) {
    this.featuresPdf = featuresPdf;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Whether the browser recognizes PDFs.")
  @JsonProperty("featuresPdf")
  public Boolean getFeaturesPdf() {
    return featuresPdf;
  }
  public void setFeaturesPdf(Boolean featuresPdf) {
    this.featuresPdf = featuresPdf;
  }


  /**
   * Whether WebRTC is supported.
   **/
  public Browser featuresWebrtc(Boolean featuresWebrtc) {
    this.featuresWebrtc = featuresWebrtc;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Whether WebRTC is supported.")
  @JsonProperty("featuresWebrtc")
  public Boolean getFeaturesWebrtc() {
    return featuresWebrtc;
  }
  public void setFeaturesWebrtc(Boolean featuresWebrtc) {
    this.featuresWebrtc = featuresWebrtc;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Browser browser = (Browser) o;

    return Objects.equals(this.family, browser.family) &&
            Objects.equals(this.version, browser.version) &&
            Objects.equals(this.lang, browser.lang) &&
            Objects.equals(this.fingerprint, browser.fingerprint) &&
            Objects.equals(this.isMobile, browser.isMobile) &&
            Objects.equals(this.viewHeight, browser.viewHeight) &&
            Objects.equals(this.viewWidth, browser.viewWidth) &&
            Objects.equals(this.featuresFlash, browser.featuresFlash) &&
            Objects.equals(this.featuresJava, browser.featuresJava) &&
            Objects.equals(this.featuresPdf, browser.featuresPdf) &&
            Objects.equals(this.featuresWebrtc, browser.featuresWebrtc);
  }

  @Override
  public int hashCode() {
    return Objects.hash(family, version, lang, fingerprint, isMobile, viewHeight, viewWidth, featuresFlash, featuresJava, featuresPdf, featuresWebrtc);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Browser {\n");
    
    sb.append("    family: ").append(toIndentedString(family)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    lang: ").append(toIndentedString(lang)).append("\n");
    sb.append("    fingerprint: ").append(toIndentedString(fingerprint)).append("\n");
    sb.append("    isMobile: ").append(toIndentedString(isMobile)).append("\n");
    sb.append("    viewHeight: ").append(toIndentedString(viewHeight)).append("\n");
    sb.append("    viewWidth: ").append(toIndentedString(viewWidth)).append("\n");
    sb.append("    featuresFlash: ").append(toIndentedString(featuresFlash)).append("\n");
    sb.append("    featuresJava: ").append(toIndentedString(featuresJava)).append("\n");
    sb.append("    featuresPdf: ").append(toIndentedString(featuresPdf)).append("\n");
    sb.append("    featuresWebrtc: ").append(toIndentedString(featuresWebrtc)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

