package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
/**
 * Information about a public message.
 */
@ApiModel(description = "Information about a public message.")

public class ConversationPublicMetadata  implements Serializable {
  
  private String rootId = null;
  private String replyToId = null;

  
  /**
   * The id of the root public message.
   **/
  public ConversationPublicMetadata rootId(String rootId) {
    this.rootId = rootId;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The id of the root public message.")
  @JsonProperty("rootId")
  public String getRootId() {
    return rootId;
  }
  public void setRootId(String rootId) {
    this.rootId = rootId;
  }


  /**
   * The id of the message this public message is replying to.
   **/
  public ConversationPublicMetadata replyToId(String replyToId) {
    this.replyToId = replyToId;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The id of the message this public message is replying to.")
  @JsonProperty("replyToId")
  public String getReplyToId() {
    return replyToId;
  }
  public void setReplyToId(String replyToId) {
    this.replyToId = replyToId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConversationPublicMetadata conversationPublicMetadata = (ConversationPublicMetadata) o;

    return Objects.equals(this.rootId, conversationPublicMetadata.rootId) &&
            Objects.equals(this.replyToId, conversationPublicMetadata.replyToId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rootId, replyToId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConversationPublicMetadata {\n");
    
    sb.append("    rootId: ").append(toIndentedString(rootId)).append("\n");
    sb.append("    replyToId: ").append(toIndentedString(replyToId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

