package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.KnowledgeDocumentResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

import java.io.Serializable;
/**
 * KnowledgeDocumentQueryResponse
 */

public class KnowledgeDocumentQueryResponse  implements Serializable {
  
  private Integer pageSize = null;
  private Integer pageNumber = null;
  private Long total = null;
  private Integer pageCount = null;
  private List<KnowledgeDocumentResponse> results = new ArrayList<KnowledgeDocumentResponse>();

  
  /**
   * Page size of the returned results.
   **/
  public KnowledgeDocumentQueryResponse pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Page size of the returned results.")
  @JsonProperty("pageSize")
  public Integer getPageSize() {
    return pageSize;
  }
  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  /**
   * Page number of the returned results.
   **/
  public KnowledgeDocumentQueryResponse pageNumber(Integer pageNumber) {
    this.pageNumber = pageNumber;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Page number of the returned results.")
  @JsonProperty("pageNumber")
  public Integer getPageNumber() {
    return pageNumber;
  }
  public void setPageNumber(Integer pageNumber) {
    this.pageNumber = pageNumber;
  }


  @ApiModelProperty(example = "null", value = "The total number of documents matching the query.")
  @JsonProperty("total")
  public Long getTotal() {
    return total;
  }


  @ApiModelProperty(example = "null", value = "The total number of pages of results, calculated according to the pageSize and the total matching documents.")
  @JsonProperty("pageCount")
  public Integer getPageCount() {
    return pageCount;
  }


  @ApiModelProperty(example = "null", value = "Documents matching the query.")
  @JsonProperty("results")
  public List<KnowledgeDocumentResponse> getResults() {
    return results;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    KnowledgeDocumentQueryResponse knowledgeDocumentQueryResponse = (KnowledgeDocumentQueryResponse) o;

    return Objects.equals(this.pageSize, knowledgeDocumentQueryResponse.pageSize) &&
            Objects.equals(this.pageNumber, knowledgeDocumentQueryResponse.pageNumber) &&
            Objects.equals(this.total, knowledgeDocumentQueryResponse.total) &&
            Objects.equals(this.pageCount, knowledgeDocumentQueryResponse.pageCount) &&
            Objects.equals(this.results, knowledgeDocumentQueryResponse.results);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageSize, pageNumber, total, pageCount, results);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class KnowledgeDocumentQueryResponse {\n");
    
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    pageNumber: ").append(toIndentedString(pageNumber)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    pageCount: ").append(toIndentedString(pageCount)).append("\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

