package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.util.ArrayList;
import java.io.IOException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ConversationReason;
import com.mypurecloud.sdk.v2.model.OpenInboundMessagingReceiptChannel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

import java.io.Serializable;
/**
 * Open Messaging rich media message structure
 */
@ApiModel(description = "Open Messaging rich media message structure")

public class OpenInboundNormalizedReceipt  implements Serializable {
  
  private String id = null;
  private OpenInboundMessagingReceiptChannel channel = null;

  private static class StatusEnumDeserializer extends StdDeserializer<StatusEnum> {
    public StatusEnumDeserializer() {
      super(StatusEnumDeserializer.class);
    }

    @Override
    public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt)
            throws IOException {
      JsonNode node = jsonParser.getCodec().readTree(jsonParser);
      return StatusEnum.fromString(node.toString().replace("\"", ""));
    }
  }
  /**
   * Message receipt status.
   */
 @JsonDeserialize(using = StatusEnumDeserializer.class)
  public enum StatusEnum {
    OUTDATEDSDKVERSION("OutdatedSdkVersion"),
    SENT("Sent"),
    DELIVERED("Delivered"),
    FAILED("Failed"),
    PUBLISHED("Published"),
    REMOVED("Removed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonCreator
    public static StatusEnum fromString(String key) {
      if (key == null) return null;

      for (StatusEnum value : StatusEnum.values()) {
        if (key.equalsIgnoreCase(value.toString())) {
          return value;
        }
      }

      return StatusEnum.values()[0];
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }
  }
  private StatusEnum status = null;
  private List<ConversationReason> reasons = new ArrayList<ConversationReason>();
  private Boolean isFinalReceipt = null;

  
  /**
   * The original unique message Id generated by the messaging platform, that this receipt message is referencing.
   **/
  public OpenInboundNormalizedReceipt id(String id) {
    this.id = id;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "The original unique message Id generated by the messaging platform, that this receipt message is referencing.")
  @JsonProperty("id")
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }


  /**
   * Channel-specific information that describes the message and the message channel/provider.
   **/
  public OpenInboundNormalizedReceipt channel(OpenInboundMessagingReceiptChannel channel) {
    this.channel = channel;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Channel-specific information that describes the message and the message channel/provider.")
  @JsonProperty("channel")
  public OpenInboundMessagingReceiptChannel getChannel() {
    return channel;
  }
  public void setChannel(OpenInboundMessagingReceiptChannel channel) {
    this.channel = channel;
  }


  /**
   * Message receipt status.
   **/
  public OpenInboundNormalizedReceipt status(StatusEnum status) {
    this.status = status;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Message receipt status.")
  @JsonProperty("status")
  public StatusEnum getStatus() {
    return status;
  }
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  /**
   * List of reasons for a message receipt that indicates the message has failed. Only used with Failed status.
   **/
  public OpenInboundNormalizedReceipt reasons(List<ConversationReason> reasons) {
    this.reasons = reasons;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "List of reasons for a message receipt that indicates the message has failed. Only used with Failed status.")
  @JsonProperty("reasons")
  public List<ConversationReason> getReasons() {
    return reasons;
  }
  public void setReasons(List<ConversationReason> reasons) {
    this.reasons = reasons;
  }


  /**
   * Indicates if this is the last message receipt for this message, or if another message receipt can be expected.
   **/
  public OpenInboundNormalizedReceipt isFinalReceipt(Boolean isFinalReceipt) {
    this.isFinalReceipt = isFinalReceipt;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Indicates if this is the last message receipt for this message, or if another message receipt can be expected.")
  @JsonProperty("isFinalReceipt")
  public Boolean getIsFinalReceipt() {
    return isFinalReceipt;
  }
  public void setIsFinalReceipt(Boolean isFinalReceipt) {
    this.isFinalReceipt = isFinalReceipt;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OpenInboundNormalizedReceipt openInboundNormalizedReceipt = (OpenInboundNormalizedReceipt) o;

    return Objects.equals(this.id, openInboundNormalizedReceipt.id) &&
            Objects.equals(this.channel, openInboundNormalizedReceipt.channel) &&
            Objects.equals(this.status, openInboundNormalizedReceipt.status) &&
            Objects.equals(this.reasons, openInboundNormalizedReceipt.reasons) &&
            Objects.equals(this.isFinalReceipt, openInboundNormalizedReceipt.isFinalReceipt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, channel, status, reasons, isFinalReceipt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OpenInboundNormalizedReceipt {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    channel: ").append(toIndentedString(channel)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    reasons: ").append(toIndentedString(reasons)).append("\n");
    sb.append("    isFinalReceipt: ").append(toIndentedString(isFinalReceipt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

