/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class GetGamificationLeaderboardRequest {
    private LocalDate startWorkday;
    private LocalDate endWorkday;
    private String metricId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public LocalDate getStartWorkday() {
        return this.startWorkday;
    }

    public void setStartWorkday(LocalDate startWorkday) {
        this.startWorkday = startWorkday;
    }

    public GetGamificationLeaderboardRequest withStartWorkday(LocalDate startWorkday) {
        this.setStartWorkday(startWorkday);
        return this;
    }

    public LocalDate getEndWorkday() {
        return this.endWorkday;
    }

    public void setEndWorkday(LocalDate endWorkday) {
        this.endWorkday = endWorkday;
    }

    public GetGamificationLeaderboardRequest withEndWorkday(LocalDate endWorkday) {
        this.setEndWorkday(endWorkday);
        return this;
    }

    public String getMetricId() {
        return this.metricId;
    }

    public void setMetricId(String metricId) {
        this.metricId = metricId;
    }

    public GetGamificationLeaderboardRequest withMetricId(String metricId) {
        this.setMetricId(metricId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetGamificationLeaderboardRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.startWorkday == null) {
            throw new IllegalStateException("Missing the required parameter 'startWorkday' when building request for GetGamificationLeaderboardRequest.");
        }
        if (this.endWorkday == null) {
            throw new IllegalStateException("Missing the required parameter 'endWorkday' when building request for GetGamificationLeaderboardRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/gamification/leaderboard").withQueryParameters("startWorkday", "", this.startWorkday).withQueryParameters("endWorkday", "", this.endWorkday).withQueryParameters("metricId", "", this.metricId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LocalDate startWorkday, LocalDate endWorkday) {
        return new Builder().withRequiredParams(startWorkday, endWorkday);
    }

    public static class Builder {
        private final GetGamificationLeaderboardRequest request = new GetGamificationLeaderboardRequest();

        private Builder() {
        }

        public Builder withStartWorkday(LocalDate startWorkday) {
            this.request.setStartWorkday(startWorkday);
            return this;
        }

        public Builder withEndWorkday(LocalDate endWorkday) {
            this.request.setEndWorkday(endWorkday);
            return this;
        }

        public Builder withMetricId(String metricId) {
            this.request.setMetricId(metricId);
            return this;
        }

        public Builder withRequiredParams(LocalDate startWorkday, LocalDate endWorkday) {
            this.request.setStartWorkday(startWorkday);
            this.request.setEndWorkday(endWorkday);
            return this;
        }

        public GetGamificationLeaderboardRequest build() {
            if (this.request.startWorkday == null) {
                throw new IllegalStateException("Missing the required parameter 'startWorkday' when building request for GetGamificationLeaderboardRequest.");
            }
            if (this.request.endWorkday == null) {
                throw new IllegalStateException("Missing the required parameter 'endWorkday' when building request for GetGamificationLeaderboardRequest.");
            }
            return this.request;
        }
    }
}

