/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ErrorInfo;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Information about a CX infrastructure as code job")
public class InfrastructureascodeJob
implements Serializable {
    private String id = null;
    private Boolean dryRun = null;
    private String acceleratorId = null;
    private Date dateSubmitted = null;
    private UserReference submittedBy = null;
    private StatusEnum status = null;
    private ErrorInfo errorInfo = null;
    private String results = null;
    private String rollbackResults = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public InfrastructureascodeJob dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether or not the job was a dry run")
    @JsonProperty(value="dryRun")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    @ApiModelProperty(example="null", value="Accelerator associated with the job")
    @JsonProperty(value="acceleratorId")
    public String getAcceleratorId() {
        return this.acceleratorId;
    }

    @ApiModelProperty(example="null", value="Date and time on which job was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateSubmitted")
    public Date getDateSubmitted() {
        return this.dateSubmitted;
    }

    @ApiModelProperty(example="null", value="User who submitted the job")
    @JsonProperty(value="submittedBy")
    public UserReference getSubmittedBy() {
        return this.submittedBy;
    }

    @ApiModelProperty(example="null", value="Job status")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Information about errors, if any")
    @JsonProperty(value="errorInfo")
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    @ApiModelProperty(example="null", value="The output results of the terraform job")
    @JsonProperty(value="results")
    public String getResults() {
        return this.results;
    }

    @ApiModelProperty(example="null", value="The results of rolling back the job if there were errors.  Not returned if job was successful.")
    @JsonProperty(value="rollbackResults")
    public String getRollbackResults() {
        return this.rollbackResults;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfrastructureascodeJob infrastructureascodeJob = (InfrastructureascodeJob)o;
        return Objects.equals(this.id, infrastructureascodeJob.id) && Objects.equals(this.dryRun, infrastructureascodeJob.dryRun) && Objects.equals(this.acceleratorId, infrastructureascodeJob.acceleratorId) && Objects.equals(this.dateSubmitted, infrastructureascodeJob.dateSubmitted) && Objects.equals(this.submittedBy, infrastructureascodeJob.submittedBy) && Objects.equals((Object)this.status, (Object)infrastructureascodeJob.status) && Objects.equals(this.errorInfo, infrastructureascodeJob.errorInfo) && Objects.equals(this.results, infrastructureascodeJob.results) && Objects.equals(this.rollbackResults, infrastructureascodeJob.rollbackResults) && Objects.equals(this.selfUri, infrastructureascodeJob.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.dryRun, this.acceleratorId, this.dateSubmitted, this.submittedBy, this.status, this.errorInfo, this.results, this.rollbackResults, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InfrastructureascodeJob {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    acceleratorId: ").append(this.toIndentedString(this.acceleratorId)).append("\n");
        sb.append("    dateSubmitted: ").append(this.toIndentedString(this.dateSubmitted)).append("\n");
        sb.append("    submittedBy: ").append(this.toIndentedString(this.submittedBy)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    rollbackResults: ").append(this.toIndentedString(this.rollbackResults)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATED("Created"),
        QUEUED("Queued"),
        RUNNING("Running"),
        COMPLETE("Complete"),
        FAILED("Failed"),
        INCOMPLETE("Incomplete");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

