/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ContentSetting;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.EventSetting;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Messaging Setting for messaging platform integrations")
public class MessagingSettingReference
implements Serializable {
    private String id = null;
    private String name = null;
    private String selfUri = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String version = null;
    private DomainEntityRef createdBy = null;
    private DomainEntityRef updatedBy = null;
    private ContentSetting content = null;
    private EventSetting event = null;

    public MessagingSettingReference id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The messaging Setting unique identifier associated with this integration")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", value="The messaging Setting profile name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="The messaging Setting profile URI")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    @ApiModelProperty(example="null", value="Date this messaging Setting was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Date this messaging Setting was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public MessagingSettingReference version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Version number")
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="User reference that created this Setting")
    @JsonProperty(value="createdBy")
    public DomainEntityRef getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="User reference that modified this Setting")
    @JsonProperty(value="updatedBy")
    public DomainEntityRef getUpdatedBy() {
        return this.updatedBy;
    }

    public MessagingSettingReference content(ContentSetting content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="null", value="Settings relating to message contents")
    @JsonProperty(value="content")
    public ContentSetting getContent() {
        return this.content;
    }

    public void setContent(ContentSetting content) {
        this.content = content;
    }

    public MessagingSettingReference event(EventSetting event) {
        this.event = event;
        return this;
    }

    @ApiModelProperty(example="null", value="Settings relating to events which may occur")
    @JsonProperty(value="event")
    public EventSetting getEvent() {
        return this.event;
    }

    public void setEvent(EventSetting event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingSettingReference messagingSettingReference = (MessagingSettingReference)o;
        return Objects.equals(this.id, messagingSettingReference.id) && Objects.equals(this.name, messagingSettingReference.name) && Objects.equals(this.selfUri, messagingSettingReference.selfUri) && Objects.equals(this.dateCreated, messagingSettingReference.dateCreated) && Objects.equals(this.dateModified, messagingSettingReference.dateModified) && Objects.equals(this.version, messagingSettingReference.version) && Objects.equals(this.createdBy, messagingSettingReference.createdBy) && Objects.equals(this.updatedBy, messagingSettingReference.updatedBy) && Objects.equals(this.content, messagingSettingReference.content) && Objects.equals(this.event, messagingSettingReference.event);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.selfUri, this.dateCreated, this.dateModified, this.version, this.createdBy, this.updatedBy, this.content, this.event);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagingSettingReference {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

