/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AssistantQueue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatchAssistantQueuesRequest {
    private String assistantId;
    private List<AssistantQueue> body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public PatchAssistantQueuesRequest withAssistantId(String assistantId) {
        this.setAssistantId(assistantId);
        return this;
    }

    public List<AssistantQueue> getBody() {
        return this.body;
    }

    public void setBody(List<AssistantQueue> body) {
        this.body = body;
    }

    public PatchAssistantQueuesRequest withBody(List<AssistantQueue> body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchAssistantQueuesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<List<AssistantQueue>> withHttpInfo() {
        if (this.assistantId == null) {
            throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PatchAssistantQueuesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchAssistantQueuesRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/assistants/{assistantId}/queues").withPathParameter("assistantId", this.assistantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String assistantId, List<AssistantQueue> body) {
        return new Builder().withRequiredParams(assistantId, body);
    }

    public static class Builder {
        private final PatchAssistantQueuesRequest request = new PatchAssistantQueuesRequest();

        private Builder() {
        }

        public Builder withAssistantId(String assistantId) {
            this.request.setAssistantId(assistantId);
            return this;
        }

        public Builder withBody(List<AssistantQueue> body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String assistantId, List<AssistantQueue> body) {
            this.request.setAssistantId(assistantId);
            this.request.setBody(body);
            return this;
        }

        public PatchAssistantQueuesRequest build() {
            if (this.request.assistantId == null) {
                throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PatchAssistantQueuesRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchAssistantQueuesRequest.");
            }
            return this.request;
        }
    }
}

