/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SmsPhoneNumber;
import java.util.HashMap;
import java.util.Map;

public class PutRoutingSmsPhonenumberRequest {
    private String phoneNumberId;
    private SmsPhoneNumber body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getPhoneNumberId() {
        return this.phoneNumberId;
    }

    public void setPhoneNumberId(String phoneNumberId) {
        this.phoneNumberId = phoneNumberId;
    }

    public PutRoutingSmsPhonenumberRequest withPhoneNumberId(String phoneNumberId) {
        this.setPhoneNumberId(phoneNumberId);
        return this;
    }

    public SmsPhoneNumber getBody() {
        return this.body;
    }

    public void setBody(SmsPhoneNumber body) {
        this.body = body;
    }

    public PutRoutingSmsPhonenumberRequest withBody(SmsPhoneNumber body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutRoutingSmsPhonenumberRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SmsPhoneNumber> withHttpInfo() {
        if (this.phoneNumberId == null) {
            throw new IllegalStateException("Missing the required parameter 'phoneNumberId' when building request for PutRoutingSmsPhonenumberRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRoutingSmsPhonenumberRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/routing/sms/phonenumbers/{phoneNumberId}").withPathParameter("phoneNumberId", this.phoneNumberId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String phoneNumberId, SmsPhoneNumber body) {
        return new Builder().withRequiredParams(phoneNumberId, body);
    }

    public static class Builder {
        private final PutRoutingSmsPhonenumberRequest request = new PutRoutingSmsPhonenumberRequest();

        private Builder() {
        }

        public Builder withPhoneNumberId(String phoneNumberId) {
            this.request.setPhoneNumberId(phoneNumberId);
            return this;
        }

        public Builder withBody(SmsPhoneNumber body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String phoneNumberId, SmsPhoneNumber body) {
            this.request.setPhoneNumberId(phoneNumberId);
            this.request.setBody(body);
            return this;
        }

        public PutRoutingSmsPhonenumberRequest build() {
            if (this.request.phoneNumberId == null) {
                throw new IllegalStateException("Missing the required parameter 'phoneNumberId' when building request for PutRoutingSmsPhonenumberRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRoutingSmsPhonenumberRequest.");
            }
            return this.request;
        }
    }
}

