/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.InfixOperator;
import com.mypurecloud.sdk.v2.model.OperandPosition;
import com.mypurecloud.sdk.v2.model.Term;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Operand
implements Serializable {
    private TypeEnum type = null;
    private Integer occurrence = null;
    private Boolean inverted = null;
    private Term term = null;
    private String topicId = null;
    private OperandPosition voiceSecondsPosition = null;
    private OperandPosition digitalWordsPosition = null;
    private InfixOperator infixOperator = null;
    private List<Operand> operands = new ArrayList<Operand>();

    public Operand type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Operand type of the category")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Operand occurrence(Integer occurrence) {
        this.occurrence = occurrence;
        return this;
    }

    @ApiModelProperty(example="null", value="The minimum number of occurrences of the defined operand type")
    @JsonProperty(value="occurrence")
    public Integer getOccurrence() {
        return this.occurrence;
    }

    public void setOccurrence(Integer occurrence) {
        this.occurrence = occurrence;
    }

    public Operand inverted(Boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    @ApiModelProperty(example="null", value="Applies a NOT modifier to the operand group")
    @JsonProperty(value="inverted")
    public Boolean getInverted() {
        return this.inverted;
    }

    public void setInverted(Boolean inverted) {
        this.inverted = inverted;
    }

    public Operand term(Term term) {
        this.term = term;
        return this;
    }

    @ApiModelProperty(example="null", value="Filter interaction by word(s)")
    @JsonProperty(value="term")
    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public Operand topicId(String topicId) {
        this.topicId = topicId;
        return this;
    }

    @ApiModelProperty(example="null", value="Filter interaction by topic ID")
    @JsonProperty(value="topicId")
    public String getTopicId() {
        return this.topicId;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public Operand voiceSecondsPosition(OperandPosition voiceSecondsPosition) {
        this.voiceSecondsPosition = voiceSecondsPosition;
        return this;
    }

    @ApiModelProperty(example="null", value="Dictates when the operand must occur in a voice interaction")
    @JsonProperty(value="voiceSecondsPosition")
    public OperandPosition getVoiceSecondsPosition() {
        return this.voiceSecondsPosition;
    }

    public void setVoiceSecondsPosition(OperandPosition voiceSecondsPosition) {
        this.voiceSecondsPosition = voiceSecondsPosition;
    }

    public Operand digitalWordsPosition(OperandPosition digitalWordsPosition) {
        this.digitalWordsPosition = digitalWordsPosition;
        return this;
    }

    @ApiModelProperty(example="null", value="Dictates when the operand must occur in a digital interaction")
    @JsonProperty(value="digitalWordsPosition")
    public OperandPosition getDigitalWordsPosition() {
        return this.digitalWordsPosition;
    }

    public void setDigitalWordsPosition(OperandPosition digitalWordsPosition) {
        this.digitalWordsPosition = digitalWordsPosition;
    }

    public Operand infixOperator(InfixOperator infixOperator) {
        this.infixOperator = infixOperator;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines a logical operation that is applied on the current operand, against the following operand")
    @JsonProperty(value="infixOperator")
    public InfixOperator getInfixOperator() {
        return this.infixOperator;
    }

    public void setInfixOperator(InfixOperator infixOperator) {
        this.infixOperator = infixOperator;
    }

    public Operand operands(List<Operand> operands) {
        this.operands = operands;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains a new level of operands")
    @JsonProperty(value="operands")
    public List<Operand> getOperands() {
        return this.operands;
    }

    public void setOperands(List<Operand> operands) {
        this.operands = operands;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Operand operand = (Operand)o;
        return Objects.equals((Object)this.type, (Object)operand.type) && Objects.equals(this.occurrence, operand.occurrence) && Objects.equals(this.inverted, operand.inverted) && Objects.equals(this.term, operand.term) && Objects.equals(this.topicId, operand.topicId) && Objects.equals(this.voiceSecondsPosition, operand.voiceSecondsPosition) && Objects.equals(this.digitalWordsPosition, operand.digitalWordsPosition) && Objects.equals(this.infixOperator, operand.infixOperator) && Objects.equals(this.operands, operand.operands);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.occurrence, this.inverted, this.term, this.topicId, this.voiceSecondsPosition, this.digitalWordsPosition, this.infixOperator, this.operands});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Operand {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    occurrence: ").append(this.toIndentedString(this.occurrence)).append("\n");
        sb.append("    inverted: ").append(this.toIndentedString(this.inverted)).append("\n");
        sb.append("    term: ").append(this.toIndentedString(this.term)).append("\n");
        sb.append("    topicId: ").append(this.toIndentedString(this.topicId)).append("\n");
        sb.append("    voiceSecondsPosition: ").append(this.toIndentedString(this.voiceSecondsPosition)).append("\n");
        sb.append("    digitalWordsPosition: ").append(this.toIndentedString(this.digitalWordsPosition)).append("\n");
        sb.append("    infixOperator: ").append(this.toIndentedString(this.infixOperator)).append("\n");
        sb.append("    operands: ").append(this.toIndentedString(this.operands)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TERM("Term"),
        TOPIC("Topic"),
        OPERANDGROUP("OperandGroup");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

