/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ResponseFilter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Used to query for responses")
public class ResponseQueryRequest
implements Serializable {
    private String queryPhrase = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private List<ResponseFilter> filters = new ArrayList<ResponseFilter>();

    public ResponseQueryRequest queryPhrase(String queryPhrase) {
        this.queryPhrase = queryPhrase;
        return this;
    }

    @ApiModelProperty(example="null", value="Query phrase to search response text and name. If not set will match all.")
    @JsonProperty(value="queryPhrase")
    public String getQueryPhrase() {
        return this.queryPhrase;
    }

    public void setQueryPhrase(String queryPhrase) {
        this.queryPhrase = queryPhrase;
    }

    public ResponseQueryRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum number of hits to return. Default: 25, Maximum: 500.")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public ResponseQueryRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Page Number")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public ResponseQueryRequest filters(List<ResponseFilter> filters) {
        this.filters = filters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filter the query results.")
    @JsonProperty(value="filters")
    public List<ResponseFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<ResponseFilter> filters) {
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseQueryRequest responseQueryRequest = (ResponseQueryRequest)o;
        return Objects.equals(this.queryPhrase, responseQueryRequest.queryPhrase) && Objects.equals(this.pageSize, responseQueryRequest.pageSize) && Objects.equals(this.pageNumber, responseQueryRequest.pageNumber) && Objects.equals(this.filters, responseQueryRequest.filters);
    }

    public int hashCode() {
        return Objects.hash(this.queryPhrase, this.pageSize, this.pageNumber, this.filters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseQueryRequest {\n");
        sb.append("    queryPhrase: ").append(this.toIndentedString(this.queryPhrase)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

