/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase;

import com.alipay.oceanbase.hbase.OHTable;
import com.alipay.oceanbase.hbase.util.KeyDefiner;
import com.alipay.oceanbase.hbase.util.OHTableFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PoolMap;

public class OHTablePool
implements Closeable {
    private final PoolMap<String, HTableInterface> tables;
    private final int maxSize;
    private final PoolMap.PoolType poolType;
    private final Configuration config;
    private final HTableInterfaceFactory tableFactory;
    private ConcurrentHashMap<String, byte[]> tableAttributes;
    private ConcurrentHashMap<String, Object> tableExtendAttributes;

    public OHTablePool() {
        this(new Configuration(), Integer.MAX_VALUE);
    }

    public OHTablePool(Configuration config, int maxSize) {
        this(config, maxSize, null, null);
    }

    public OHTablePool(Configuration config, int maxSize, HTableInterfaceFactory tableFactory) {
        this(config, maxSize, tableFactory, PoolMap.PoolType.Reusable);
    }

    public OHTablePool(Configuration config, int maxSize, PoolMap.PoolType poolType) {
        this(config, maxSize, null, poolType);
    }

    public OHTablePool(Configuration config, int maxSize, HTableInterfaceFactory tableFactory, PoolMap.PoolType poolType) {
        this(config, maxSize, null, null, poolType);
    }

    public OHTablePool(Configuration config, int maxSize, HTableInterfaceFactory tableFactory, ExecutorService createTableExecutor, PoolMap.PoolType poolType) {
        this.config = config == null ? new Configuration() : config;
        this.maxSize = maxSize;
        this.tableFactory = tableFactory == null ? (createTableExecutor == null ? new OHTableFactory(this.config, this) : new OHTableFactory(this.config, this, createTableExecutor)) : tableFactory;
        if (poolType == null) {
            this.poolType = PoolMap.PoolType.Reusable;
        } else {
            switch (poolType) {
                case Reusable: 
                case ThreadLocal: {
                    this.poolType = poolType;
                    break;
                }
                default: {
                    this.poolType = PoolMap.PoolType.Reusable;
                }
            }
        }
        this.tables = new PoolMap(this.poolType, this.maxSize);
    }

    public HTableInterface getTable(String tableName) {
        HTableInterface table = this.findOrCreateTable(tableName);
        if (table instanceof PooledOHTable) {
            return table;
        }
        return new PooledOHTable(table);
    }

    private HTableInterface findOrCreateTable(String tableName) {
        HTableInterface table = (HTableInterface)this.tables.get((Object)tableName);
        if (table == null) {
            table = this.createHTable(tableName);
        }
        return table;
    }

    public HTableInterface getTable(byte[] tableName) {
        return this.getTable(Bytes.toString((byte[])tableName));
    }

    public void putTable(HTableInterface table) throws IOException {
        if (!(table instanceof PooledOHTable)) {
            throw new IllegalArgumentException("not a pooled table: " + table);
        }
        this.returnTable(((PooledOHTable)table).getWrappedTable());
    }

    private void returnTable(HTableInterface table) throws IOException {
        String tableName = Bytes.toString((byte[])table.getTableName());
        if (this.tables.size((Object)tableName) >= this.maxSize) {
            this.tables.remove((Object)tableName, (Object)table);
            this.tableFactory.releaseHTableInterface(table);
            return;
        }
        this.tables.put((Object)tableName, (Object)table);
    }

    protected HTableInterface createHTable(String tableName) {
        return this.tableFactory.createHTableInterface(this.config, Bytes.toBytes((String)tableName));
    }

    public void closeTablePool(String tableName) throws IOException {
        Collection tables = this.tables.values((Object)tableName);
        if (tables != null) {
            for (HTableInterface table : tables) {
                this.tableFactory.releaseHTableInterface(table);
            }
        }
        this.tables.remove((Object)tableName);
    }

    public void closeTablePool(byte[] tableName) throws IOException {
        this.closeTablePool(Bytes.toString((byte[])tableName));
    }

    @Override
    public void close() throws IOException {
        for (String tableName : this.tables.keySet()) {
            this.closeTablePool(tableName);
        }
        this.tables.clear();
        if (this.tableFactory != null && this.tableFactory instanceof OHTableFactory) {
            ((OHTableFactory)this.tableFactory).close();
        }
    }

    int getCurrentPoolSize(String tableName) {
        return this.tables.size((Object)tableName);
    }

    public void setParamUrl(String tableName, String paramUrl) {
        this.setTableAttribute(tableName, "hbase.oceanbase.paramURL", Bytes.toBytes((String)paramUrl));
    }

    public String getParamUrl(String tableName) {
        return Bytes.toString((byte[])this.getTableAttribute(tableName, "hbase.oceanbase.paramURL"));
    }

    public void setFullUserName(String tableName, String fullUserName) {
        this.setTableAttribute(tableName, "hbase.oceanbase.fullUserName", Bytes.toBytes((String)fullUserName));
    }

    public String getFullUserName(String tableName) {
        return Bytes.toString((byte[])this.getTableAttribute(tableName, "hbase.oceanbase.fullUserName"));
    }

    public void setPassword(String tableName, String password) {
        this.setTableAttribute(tableName, "hbase.oceanbase.password", Bytes.toBytes((String)password));
    }

    public String getPassword(String tableName) {
        return Bytes.toString((byte[])this.getTableAttribute(tableName, "hbase.oceanbase.password"));
    }

    public void setSysUserName(String tableName, String sysUserName) {
        this.setTableAttribute(tableName, "hbase.oceanbase.sysUserName", Bytes.toBytes((String)sysUserName));
    }

    public String getSysUserName(String tableName) {
        return Bytes.toString((byte[])this.getTableAttribute(tableName, "hbase.oceanbase.sysPassword"));
    }

    public void setSysPassword(String tableName, String sysPassword) {
        this.setTableAttribute(tableName, "hbase.oceanbase.sysPassword", Bytes.toBytes((String)sysPassword));
    }

    public String getSysPassword(String tableName) {
        return Bytes.toString((byte[])this.getTableAttribute(tableName, "hbase.oceanbase.sysPassword"));
    }

    public void setAutoFlush(String tableName, boolean autoFlush) {
        this.setAutoFlush(tableName, autoFlush, autoFlush);
    }

    public void setAutoFlush(String tableName, boolean autoFlush, boolean clearBufferOnFail) {
        this.setTableAttribute(tableName, "hbase.htable.pool.auto.flush", Bytes.toBytes((boolean)autoFlush));
        this.setTableAttribute(tableName, "hbase.htable.pool.clear.buffer.on.fail", Bytes.toBytes((boolean)clearBufferOnFail));
    }

    public boolean getAutoFlush(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.htable.pool.auto.flush");
        return attr == null || Bytes.toBoolean((byte[])attr);
    }

    public boolean getClearBufferOnFail(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.htable.pool.clear.buffer.on.fail");
        return attr == null || Bytes.toBoolean((byte[])attr);
    }

    public void setWriteBufferSize(String tableName, long writeBufferSize) throws IOException {
        this.setTableAttribute(tableName, "hbase.htable.pool.write.buffer.size", Bytes.toBytes((long)writeBufferSize));
    }

    public long getWriteBufferSize(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.htable.pool.write.buffer.size");
        return attr == null ? this.config.getLong("hbase.client.write.buffer", 0x200000L) : Bytes.toLong((byte[])attr);
    }

    public void setOperationTimeout(String tableName, int operationTimeout) {
        this.setTableAttribute(tableName, "hbase.htable.pool.operation.timeout", Bytes.toBytes((int)operationTimeout));
    }

    public void refreshTableEntry(String tableName, String family, boolean hasTestLoad) throws Exception {
        ((OHTable)((PooledOHTable)this.getTable(tableName)).getTable()).refreshTableEntry(family, hasTestLoad);
    }

    public int getOperationTimeout(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.htable.pool.operation.timeout");
        if (attr == null) {
            return Integer.MAX_VALUE;
        }
        return Bytes.toInt((byte[])attr);
    }

    public void setOdpAddr(String tableName, String odpAddr) {
        this.setTableAttribute(tableName, "hbase.oceanbase.odpAddr", Bytes.toBytes((String)odpAddr));
    }

    public String getOdpAddr(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.oceanbase.odpAddr");
        if (attr == null) {
            return "";
        }
        return Bytes.toString((byte[])attr);
    }

    public void setOdpPort(String tableName, int odpPort) {
        this.setTableAttribute(tableName, "hbase.oceanbase.odpPort", Bytes.toBytes((int)odpPort));
    }

    public int getOdpPort(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.oceanbase.odpPort");
        return attr == null ? this.config.getInt("hbase.oceanbase.odpPort", -1) : Bytes.toInt((byte[])attr);
    }

    public void setOdpMode(String tableName, boolean odpMode) {
        this.setTableAttribute(tableName, "hbase.oceanbase.odpMode", Bytes.toBytes((boolean)odpMode));
    }

    public boolean getOdpMode(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.oceanbase.odpMode");
        return attr != null && Bytes.toBoolean((byte[])attr);
    }

    public void setDatabase(String tableName, String database) {
        this.setTableAttribute(tableName, "hbase.oceanbase.database", Bytes.toBytes((String)database));
    }

    public String getDatabase(String tableName) {
        byte[] attr = this.getTableAttribute(tableName, "hbase.oceanbase.database");
        if (attr == null) {
            return "";
        }
        return Bytes.toString((byte[])attr);
    }

    private void setTableAttribute(String tableName, String attributeName, byte[] value) {
        if (this.tableAttributes == null && value == null) {
            return;
        }
        if (this.tableAttributes == null) {
            this.tableAttributes = new ConcurrentHashMap();
        }
        String name = KeyDefiner.genPooledOHTableAttributeName(tableName, attributeName);
        if (value == null) {
            this.tableAttributes.remove(name);
            if (this.tableAttributes.isEmpty()) {
                this.tableAttributes = null;
            }
        } else {
            this.tableAttributes.put(name, value);
        }
    }

    public byte[] getTableAttribute(String tableName, String attributeName) {
        if (this.tableAttributes == null) {
            return null;
        }
        String name = KeyDefiner.genPooledOHTableAttributeName(tableName, attributeName);
        return this.tableAttributes.get(name);
    }

    private void setTableExtendAttribute(String tableName, String attributeName, Object value) {
        if (this.tableExtendAttributes == null && value == null) {
            return;
        }
        if (this.tableExtendAttributes == null) {
            this.tableExtendAttributes = new ConcurrentHashMap();
        }
        String name = KeyDefiner.genPooledOHTableAttributeName(tableName, attributeName);
        if (value == null) {
            this.tableExtendAttributes.remove(name);
            if (this.tableExtendAttributes.isEmpty()) {
                this.tableExtendAttributes = null;
            }
        } else {
            this.tableExtendAttributes.put(name, value);
        }
    }

    public Object getTableExtendAttribute(String tableName, String attributeName) {
        if (this.tableExtendAttributes == null) {
            return null;
        }
        String name = KeyDefiner.genPooledOHTableAttributeName(tableName, attributeName);
        return this.tableExtendAttributes.get(name);
    }

    public void setRuntimeBatchExecutor(String tableName, ExecutorService runtimeBatchExecutor) {
        this.setTableExtendAttribute(tableName, "hbase.oceanbase.batch.executor", runtimeBatchExecutor);
    }

    public ExecutorService getRuntimeBatchExecutor(String tableName) {
        return (ExecutorService)this.getTableExtendAttribute(tableName, "hbase.oceanbase.batch.executor");
    }

    class PooledOHTable
    implements HTableInterface {
        private HTableInterface table;

        public PooledOHTable(HTableInterface table) {
            this.table = table;
        }

        public byte[] getTableName() {
            return this.table.getTableName();
        }

        public Configuration getConfiguration() {
            return this.table.getConfiguration();
        }

        public HTableDescriptor getTableDescriptor() throws IOException {
            return this.table.getTableDescriptor();
        }

        public boolean exists(Get get) throws IOException {
            return this.table.exists(get);
        }

        public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
            this.table.batch(actions, results);
        }

        public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
            return this.table.batch(actions);
        }

        public Result get(Get get) throws IOException {
            return this.table.get(get);
        }

        public Result[] get(List<Get> gets) throws IOException {
            return this.table.get(gets);
        }

        public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
            return this.table.getRowOrBefore(row, family);
        }

        public ResultScanner getScanner(Scan scan) throws IOException {
            return this.table.getScanner(scan);
        }

        public ResultScanner getScanner(byte[] family) throws IOException {
            return this.table.getScanner(family);
        }

        public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
            return this.table.getScanner(family, qualifier);
        }

        public void put(Put put) throws IOException {
            this.table.put(put);
        }

        public void put(List<Put> puts) throws IOException {
            this.table.put(puts);
        }

        public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
            return this.table.checkAndPut(row, family, qualifier, value, put);
        }

        public void delete(Delete delete) throws IOException {
            this.table.delete(delete);
        }

        public void delete(List<Delete> deletes) throws IOException {
            this.table.delete(deletes);
        }

        public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
            return this.table.checkAndDelete(row, family, qualifier, value, delete);
        }

        public Result increment(Increment increment) throws IOException {
            return this.table.increment(increment);
        }

        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
            return this.table.incrementColumnValue(row, family, qualifier, amount);
        }

        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
            return this.table.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
        }

        public boolean isAutoFlush() {
            return this.table.isAutoFlush();
        }

        public void flushCommits() throws IOException {
            this.table.flushCommits();
        }

        public void close() throws IOException {
            OHTablePool.this.returnTable(this.table);
        }

        public RowLock lockRow(byte[] row) throws IOException {
            return this.table.lockRow(row);
        }

        public void unlockRow(RowLock rl) throws IOException {
            this.table.unlockRow(rl);
        }

        public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol, byte[] row) {
            return (T)this.table.coprocessorProxy(protocol, row);
        }

        public <T extends CoprocessorProtocol, R> Map<byte[], R> coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws IOException, Throwable {
            return this.table.coprocessorExec(protocol, startKey, endKey, callable);
        }

        public <T extends CoprocessorProtocol, R> void coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws IOException, Throwable {
            this.table.coprocessorExec(protocol, startKey, endKey, callable, callback);
        }

        public String toString() {
            return "PooledOHTable{, table=" + this.table + '}';
        }

        HTableInterface getWrappedTable() {
            return this.table;
        }

        public void mutateRow(RowMutations rm) throws IOException {
            this.table.mutateRow(rm);
        }

        public Result append(Append append) throws IOException {
            return this.table.append(append);
        }

        public void setAutoFlush(boolean autoFlush) {
            this.table.setAutoFlush(autoFlush);
        }

        public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
            this.table.setAutoFlush(autoFlush, clearBufferOnFail);
        }

        public long getWriteBufferSize() {
            return this.table.getWriteBufferSize();
        }

        public void setWriteBufferSize(long writeBufferSize) throws IOException {
            this.table.setWriteBufferSize(writeBufferSize);
        }

        public HTableInterface getTable() {
            return this.table;
        }

        public byte[][] getStartKeys() throws IOException {
            return ((OHTable)this.table).getStartKeys();
        }

        public byte[][] getEndKeys() throws IOException {
            return ((OHTable)this.table).getEndKeys();
        }

        public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
            return ((OHTable)this.table).getStartEndKeys();
        }
    }
}

