package com.onepointsixtwo.dagger_viewmodel;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * The InjectViewModel annotation is the only piece of code present in this part of the library. It is used by the <a
 * href="https://github.com/onepointsixtwo/dagger_viewmodel_processor">annotations processor</a> and the <a
 * href="https://github.com/onepointsixtwo/dagger_viewmodel_android">Android specific components</a> to allow DI of
 * ViewModels.
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface InjectViewModel {
    boolean useActivityScope() default false;
}
