/*
 * Decompiled with CFR 0.152.
 */
package com.rainerhahnekamp.sneakythrow;

import com.rainerhahnekamp.sneakythrow.functional.SneakyBiConsumer;
import com.rainerhahnekamp.sneakythrow.functional.SneakyBiFunction;
import com.rainerhahnekamp.sneakythrow.functional.SneakyBiPredicate;
import com.rainerhahnekamp.sneakythrow.functional.SneakyBinaryOperator;
import com.rainerhahnekamp.sneakythrow.functional.SneakyConsumer;
import com.rainerhahnekamp.sneakythrow.functional.SneakyFunction;
import com.rainerhahnekamp.sneakythrow.functional.SneakyPredicate;
import com.rainerhahnekamp.sneakythrow.functional.SneakyRunnable;
import com.rainerhahnekamp.sneakythrow.functional.SneakySupplier;
import com.rainerhahnekamp.sneakythrow.functional.SneakyUnaryOperator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class Sneaky {
    public static <T> T sneak(SneakySupplier<T> supplier) {
        return Sneaky.sneaked(supplier).get();
    }

    public static <T, U> BiConsumer<T, U> sneaked(SneakyBiConsumer<T, U> biConsumer) {
        return (t, u) -> {
            try {
                biConsumer.accept(t, u);
            }
            catch (Exception exception) {
                Sneaky.throwUnchecked(exception);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> sneaked(SneakyBiFunction<T, U, R> biFunction) {
        return (t, u) -> {
            try {
                return biFunction.apply(t, u);
            }
            catch (Exception exception) {
                Sneaky.throwUnchecked(exception);
                return null;
            }
        };
    }

    public static <T> BinaryOperator<T> sneaked(SneakyBinaryOperator<T> binaryOperator) {
        return (t1, t2) -> {
            try {
                return binaryOperator.apply(t1, t2);
            }
            catch (Exception exception) {
                Sneaky.throwUnchecked(exception);
                return null;
            }
        };
    }

    public static <T, U> BiPredicate<T, U> sneaked(SneakyBiPredicate<T, U> biPredicate) {
        return (t, u) -> {
            try {
                return biPredicate.test(t, u);
            }
            catch (Exception exception) {
                Sneaky.throwUnchecked(exception);
                return false;
            }
        };
    }

    public static <T> Consumer<T> sneaked(SneakyConsumer<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                Sneaky.throwUnchecked(exception);
            }
        };
    }

    public static <T, R> Function<T, R> sneaked(SneakyFunction<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                Sneaky.throwUnchecked(exception);
                return null;
            }
        };
    }

    public static <T> Predicate<T> sneaked(SneakyPredicate<T> predicate) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Exception exception) {
                Sneaky.throwUnchecked(exception);
                return false;
            }
        };
    }

    public static Runnable sneaked(SneakyRunnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                Sneaky.throwUnchecked(exception);
            }
        };
    }

    public static <T> Supplier<T> sneaked(SneakySupplier<T> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                Sneaky.throwUnchecked(exception);
                return null;
            }
        };
    }

    public static <T> UnaryOperator<T> sneaked(SneakyUnaryOperator<T> unaryOperator) {
        return t -> {
            try {
                return unaryOperator.apply(t);
            }
            catch (Exception exception) {
                Sneaky.throwUnchecked(exception);
                return null;
            }
        };
    }

    private static <T extends Throwable> void throwUnchecked(Throwable t) throws T {
        throw t;
    }
}

