/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal;

import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.exceptions.InvalidResourceName;
import com.schibsted.security.strongbox.sdk.internal.AWSResourceNameSerialization;
import com.schibsted.security.strongbox.sdk.internal.access.AccessLevel;
import com.schibsted.security.strongbox.sdk.types.Region;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;

public final class IAMPolicyName {
    public final SecretsGroupIdentifier group;
    public final AccessLevel accessLevel;

    public IAMPolicyName(SecretsGroupIdentifier group, AccessLevel accessLevel) {
        this.group = group;
        this.accessLevel = accessLevel;
    }

    public String toString() {
        return String.format("%s_%s_%s_%s", new Object[]{"strongbox", this.group.region.getName(), AWSResourceNameSerialization.encodeSecretsGroupName(this.group.name), this.accessLevel});
    }

    public static IAMPolicyName fromString(String wrappedAWSResourceName) {
        String[] parts = wrappedAWSResourceName.split("_");
        if (!parts[0].equals("strongbox")) {
            throw new InvalidResourceName(wrappedAWSResourceName, "An IAM policy name should start with strongbox");
        }
        if (parts.length != 4) {
            throw new InvalidResourceName(wrappedAWSResourceName, "An IAM policy name should have exactly 4 parts");
        }
        Region region = Region.fromName(parts[1]);
        String name = AWSResourceNameSerialization.decodeSecretsGroupName(parts[2]);
        SecretsGroupIdentifier group = new SecretsGroupIdentifier(region, name);
        AccessLevel accessLevel = AccessLevel.fromString(parts[3]);
        return new IAMPolicyName(group, accessLevel);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IAMPolicyName) {
            IAMPolicyName other = (IAMPolicyName)obj;
            return Objects.equal((Object)this.group, (Object)other.group) && Objects.equal((Object)((Object)this.accessLevel), (Object)((Object)other.accessLevel));
        }
        return false;
    }
}

