/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.config;

import com.schibsted.security.strongbox.sdk.internal.config.AWSCLIConfigFile;
import com.schibsted.security.strongbox.sdk.internal.config.AWSConfig;
import com.schibsted.security.strongbox.sdk.internal.config.AWSConfigPropertyKey;
import com.schibsted.security.strongbox.sdk.types.ProfileIdentifier;
import com.schibsted.security.strongbox.sdk.types.arn.RoleARN;
import java.io.File;
import java.util.Optional;
import java.util.function.Function;

public class ConfigProviderChain {
    private final Optional<AWSConfig> credentials;
    private final Optional<AWSConfig> config;

    public ConfigProviderChain() {
        Optional<File> credentialsFile = AWSCLIConfigFile.getCredentialProfilesFile();
        Optional<File> configFile = AWSCLIConfigFile.getConfigFile();
        Optional<AWSCLIConfigFile.Config> credentialsProvider = credentialsFile.map(AWSCLIConfigFile::new).map(AWSCLIConfigFile::getConfig);
        Optional<AWSCLIConfigFile.Config> configProvider = configFile.map(AWSCLIConfigFile::new).map(AWSCLIConfigFile::getConfig);
        this.credentials = credentialsProvider.map(AWSConfig::new);
        this.config = configProvider.map(AWSConfig::new);
    }

    public boolean hasConfig() {
        return this.credentials.isPresent() || this.config.isPresent();
    }

    public Optional<String> getMFASerial(ProfileIdentifier profile) {
        return this.getPropertyFromEitherConfigFile(c -> c.getMFASerial(profile));
    }

    public Optional<ProfileIdentifier> getSourceProfile(ProfileIdentifier profile) {
        return this.getPropertyFromEitherConfigFile(c -> c.getSourceProfile(profile));
    }

    public Optional<RoleARN> getRoleArn(ProfileIdentifier profile) {
        return this.getPropertyFromEitherConfigFile(c -> c.getRoleArn(profile));
    }

    public Optional<String> getAWSAccessKeyId(ProfileIdentifier profile) {
        return this.getPropertyFromEitherConfigFile(c -> c.getAWSAccessKeyId(profile));
    }

    public String getAWSAccessKeyIdOrThrow(ProfileIdentifier profile) {
        return (String)this.getPropertyFromEitherConfigFileOrThrow(c -> c.getAWSAccessKeyId(profile), profile, AWSConfigPropertyKey.AWS_ACCESS_KEY_ID);
    }

    public Optional<String> getAWSSecretKey(ProfileIdentifier profile) {
        return this.getPropertyFromEitherConfigFile(c -> c.getAWSSecretKey(profile));
    }

    public String getAWSSecretKeyOrThrow(ProfileIdentifier profile) {
        return (String)this.getPropertyFromEitherConfigFileOrThrow(c -> c.getAWSSecretKey(profile), profile, AWSConfigPropertyKey.AWS_SECRET_ACCESS_KEY);
    }

    private <T> Optional<T> getPropertyFromEitherConfigFile(Function<AWSConfig, Optional<T>> fetchPropertyFunction) {
        Optional result = Optional.empty();
        if (this.credentials.isPresent()) {
            result = fetchPropertyFunction.apply(this.credentials.get());
        }
        if (!result.isPresent() && this.config.isPresent()) {
            result = fetchPropertyFunction.apply(this.config.get());
        }
        return result;
    }

    private <T> T getPropertyFromEitherConfigFileOrThrow(Function<AWSConfig, Optional<T>> f, ProfileIdentifier profile, AWSConfigPropertyKey propertyKey) {
        Optional<T> result = this.getPropertyFromEitherConfigFile(f);
        if (!result.isPresent()) {
            throw new IllegalStateException(String.format("No property '%s' set for profile '%s'", new Object[]{propertyKey, profile.name}));
        }
        return result.get();
    }
}

