/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.config.credentials;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.schibsted.security.strongbox.sdk.internal.ClientConfigurationHelper;
import com.schibsted.security.strongbox.sdk.internal.RegionResolver;
import com.schibsted.security.strongbox.sdk.internal.config.AWSConfigPropertyKey;
import com.schibsted.security.strongbox.sdk.internal.config.ConfigProviderChain;
import com.schibsted.security.strongbox.sdk.internal.config.credentials.MFAToken;
import com.schibsted.security.strongbox.sdk.internal.config.credentials.SessionCache;
import com.schibsted.security.strongbox.sdk.types.ClientConfiguration;
import com.schibsted.security.strongbox.sdk.types.ProfileIdentifier;
import com.schibsted.security.strongbox.sdk.types.arn.RoleARN;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.function.Supplier;

public class ProfileCredentialProvider
implements AWSCredentialsProvider {
    private ClientConfiguration clientConfiguration;
    private ProfileIdentifier profile;
    private Supplier<MFAToken> mfaTokenSupplier;

    public ProfileCredentialProvider(ClientConfiguration clientConfiguration, ProfileIdentifier profile, Supplier<MFAToken> mfaTokenSupplier) {
        this.clientConfiguration = clientConfiguration;
        this.profile = profile;
        this.mfaTokenSupplier = mfaTokenSupplier;
    }

    public AWSCredentials getCredentials() {
        return this.getCredentialsFromProfile(this.profile);
    }

    public void refresh() {
    }

    private AWSCredentials getCredentialsFromProfile(ProfileIdentifier profile) {
        ConfigProviderChain configProvider = new ConfigProviderChain();
        if (!configProvider.hasConfig()) {
            throw new IllegalStateException("When using '--profile', an AWS credentials or config file must be present");
        }
        Optional<RoleARN> roleToAssume = configProvider.getRoleArn(profile);
        if (roleToAssume.isPresent()) {
            return this.assumeRole(this.clientConfiguration, configProvider, profile, roleToAssume.get());
        }
        return this.getStaticCredentials(configProvider, profile);
    }

    private AWSCredentials assumeRole(ClientConfiguration clientConfiguration, ConfigProviderChain configProvider, ProfileIdentifier profile, RoleARN roleToAssume) {
        Optional<ProfileIdentifier> sourceProfile = configProvider.getSourceProfile(profile);
        if (!sourceProfile.isPresent()) {
            throw new IllegalStateException(String.format("'%s' must be specified when using '%s' for profile '%s'", new Object[]{AWSConfigPropertyKey.SOURCE_PROFILE, AWSConfigPropertyKey.ROLE_ARN, profile.name}));
        }
        SessionCache sessionCache = new SessionCache(profile, roleToAssume);
        Optional<BasicSessionCredentials> cachedCredentials = sessionCache.load();
        if (cachedCredentials.isPresent()) {
            return (AWSCredentials)cachedCredentials.get();
        }
        AWSStaticCredentialsProvider staticCredentialsProvider = new AWSStaticCredentialsProvider(this.getStaticCredentials(configProvider, sourceProfile.get()));
        AWSSecurityTokenService client = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)staticCredentialsProvider)).withClientConfiguration(ClientConfigurationHelper.transformAndVerifyOrThrow(clientConfiguration))).withRegion(RegionResolver.getRegion())).build();
        String sessionId = String.format("strongbox-cli-session-%s", ZonedDateTime.now().toEpochSecond());
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.withRoleArn(roleToAssume.toArn()).withRoleSessionName(sessionId);
        Optional<String> mfaSerial = configProvider.getMFASerial(profile);
        if (mfaSerial.isPresent()) {
            MFAToken mfaToken = this.mfaTokenSupplier.get();
            request.withSerialNumber(mfaSerial.get()).withTokenCode(mfaToken.value);
        }
        AssumeRoleResult result = client.assumeRole(request);
        Credentials credentials = result.getCredentials();
        BasicSessionCredentials basicSessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        sessionCache.save(result.getAssumedRoleUser(), basicSessionCredentials, ZonedDateTime.ofInstant(credentials.getExpiration().toInstant(), ZoneId.of("UTC")));
        return basicSessionCredentials;
    }

    private AWSCredentials getStaticCredentials(ConfigProviderChain configProviderChain, ProfileIdentifier profile) {
        return new BasicAWSCredentials(configProviderChain.getAWSAccessKeyIdOrThrow(profile), configProviderChain.getAWSSecretKeyOrThrow(profile));
    }
}

