/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.encryption;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.encryptionsdk.AwsCrypto;
import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.kms.KmsMasterKey;
import com.amazonaws.encryptionsdk.kms.KmsMasterKeyProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.schibsted.security.strongbox.sdk.exceptions.UnlimitedEncryptionNotSetException;
import com.schibsted.security.strongbox.sdk.internal.ClientConfigurationHelper;
import com.schibsted.security.strongbox.sdk.internal.encryption.EncryptionContext;
import com.schibsted.security.strongbox.sdk.internal.encryption.Encryptor;
import com.schibsted.security.strongbox.sdk.internal.encryption.KMSManager;
import com.schibsted.security.strongbox.sdk.internal.interfaces.ManagedResource;
import com.schibsted.security.strongbox.sdk.types.ClientConfiguration;
import com.schibsted.security.strongbox.sdk.types.EncryptionStrength;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;
import java.util.Map;
import java.util.Optional;

public class KMSEncryptor
implements Encryptor,
ManagedResource {
    private final AwsCrypto crypto;
    private final KMSManager kmsManager;
    private final AWSCredentialsProvider awsCredentials;
    private final SecretsGroupIdentifier groupIdentifier;
    private final ClientConfiguration clientConfiguration;
    private Optional<KmsMasterKeyProvider> prov = Optional.empty();
    private Optional<String> keyArn = Optional.empty();

    public KMSEncryptor(KMSManager kmsManager, AWSCredentialsProvider awsCredentials, ClientConfiguration clientConfiguration, SecretsGroupIdentifier groupIdentifier, AwsCrypto awsCrypto, EncryptionStrength encryptionStrength) {
        this.awsCredentials = awsCredentials;
        this.clientConfiguration = clientConfiguration;
        this.groupIdentifier = groupIdentifier;
        this.kmsManager = kmsManager;
        if (encryptionStrength.equals((Object)EncryptionStrength.AES_128)) {
            awsCrypto.setEncryptionAlgorithm(CryptoAlgorithm.ALG_AES_128_GCM_IV12_TAG16_HKDF_SHA256_ECDSA_P256);
        } else if (encryptionStrength.equals((Object)EncryptionStrength.AES_256)) {
            awsCrypto.setEncryptionAlgorithm(CryptoAlgorithm.ALG_AES_256_GCM_IV12_TAG16_HKDF_SHA384_ECDSA_P384);
        } else {
            throw new IllegalArgumentException(String.format("Unrecognized encryption strength %s", encryptionStrength.toString()));
        }
        this.crypto = awsCrypto;
    }

    public static KMSEncryptor fromCredentials(AWSCredentialsProvider awsCredentials, ClientConfiguration clientConfiguration, SecretsGroupIdentifier groupIdentifier, EncryptionStrength encryptionStrength) {
        KMSManager manager = KMSManager.fromCredentials(awsCredentials, clientConfiguration, groupIdentifier);
        return new KMSEncryptor(manager, awsCredentials, clientConfiguration, groupIdentifier, new AwsCrypto(), encryptionStrength);
    }

    @Override
    public String encrypt(String plaintext, EncryptionContext context) {
        return (String)this.crypto.encryptString((MasterKeyProvider)this.getProvider(), plaintext, context.toMap()).getResult();
    }

    @Override
    public String decrypt(String ciphertext, EncryptionContext context) {
        CryptoResult decryptResult = this.crypto.decryptString((MasterKeyProvider)this.getProvider(), ciphertext);
        this.verify(decryptResult, context);
        return (String)decryptResult.getResult();
    }

    boolean isInvalidKeyException(AwsCryptoException e) {
        return e.getMessage().equals("java.security.InvalidKeyException: Illegal key size");
    }

    @Override
    public byte[] encrypt(byte[] plaintext, EncryptionContext context) {
        try {
            return (byte[])this.crypto.encryptData((MasterKeyProvider)this.getProvider(), plaintext, context.toMap()).getResult();
        }
        catch (AwsCryptoException e) {
            if (this.isInvalidKeyException(e)) {
                throw new UnlimitedEncryptionNotSetException();
            }
            throw e;
        }
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, EncryptionContext context) {
        try {
            CryptoResult decryptResult = this.crypto.decryptData((MasterKeyProvider)this.getProvider(), ciphertext);
            this.verify(decryptResult, context);
            return (byte[])decryptResult.getResult();
        }
        catch (AwsCryptoException e) {
            if (this.isInvalidKeyException(e)) {
                throw new UnlimitedEncryptionNotSetException();
            }
            throw e;
        }
    }

    private void verify(CryptoResult<?, KmsMasterKey> decryptResult, EncryptionContext context) {
        if (!((String)decryptResult.getMasterKeyIds().get(0)).equals(this.getKeyArn())) {
            throw new IllegalStateException("Wrong key id!");
        }
        for (Map.Entry<String, String> e : context.toMap().entrySet()) {
            if (e.getValue().equals(decryptResult.getEncryptionContext().get(e.getKey()))) continue;
            throw new IllegalStateException("Wrong Encryption Context!");
        }
    }

    public byte[] generateRandom(Integer numberOfBytes) {
        return this.kmsManager.generateRandom(numberOfBytes);
    }

    @Override
    public String create() {
        return this.kmsManager.create();
    }

    public String create(boolean allowExistingPendingDeletedOrDisabledKey) {
        return this.kmsManager.create(allowExistingPendingDeletedOrDisabledKey);
    }

    @Override
    public void delete() {
        this.kmsManager.delete();
    }

    @Override
    public Optional<String> awsAdminPolicy() {
        return this.kmsManager.awsAdminPolicy();
    }

    @Override
    public Optional<String> awsReadOnlyPolicy() {
        return this.kmsManager.awsReadOnlyPolicy();
    }

    @Override
    public String getArn() {
        return this.kmsManager.getArn();
    }

    @Override
    public boolean exists() {
        return this.kmsManager.exists();
    }

    public boolean exists(boolean allowExistingPendingDeletedOrDisabledKey) {
        return this.kmsManager.exists(allowExistingPendingDeletedOrDisabledKey);
    }

    public int pendingDeletionWindowInDays() {
        return this.kmsManager.pendingDeletionWindowInDays();
    }

    protected KmsMasterKeyProvider getProvider() {
        if (!this.prov.isPresent()) {
            Region region = RegionUtils.getRegion((String)this.groupIdentifier.region.getName());
            this.prov = Optional.of(new KmsMasterKeyProvider(this.awsCredentials, region, ClientConfigurationHelper.transformAndVerifyOrThrow(this.clientConfiguration), this.getKeyArn()));
        }
        return this.prov.get();
    }

    protected String getKeyArn() {
        if (!this.keyArn.isPresent()) {
            this.keyArn = Optional.of(this.kmsManager.getArn());
        }
        return this.keyArn.get();
    }
}

