/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.kv4j.generated;

import com.schibsted.security.strongbox.sdk.internal.converter.ByteArrayConverter;
import com.schibsted.security.strongbox.sdk.internal.converter.Converters;
import com.schibsted.security.strongbox.sdk.internal.converter.FormattedTimestamp;
import com.schibsted.security.strongbox.sdk.internal.converter.LongConverter;
import com.schibsted.security.strongbox.sdk.internal.converter.SecretIdentifierConverter;
import com.schibsted.security.strongbox.sdk.internal.converter.StateConverter;
import com.schibsted.security.strongbox.sdk.internal.converter.StringConverter;
import com.schibsted.security.strongbox.sdk.internal.converter.ZonedDateTimeConverter;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.RSEF;
import com.schibsted.security.strongbox.sdk.types.RawSecretEntry;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;
import com.schibsted.security.strongbox.sdk.types.State;
import java.time.ZonedDateTime;

public class Config {
    public static final int KEY = 1;
    public static final int VERSION = 2;
    public static final int STATE = 3;
    public static final int NOT_BEFORE = 4;
    public static final int NOT_AFTER = 5;
    public static final int VALUE = 6;
    public static RSEF.PartitionKey<RawSecretEntry, SecretIdentifier> name = new RSEF.PartitionKey(1);
    public static RSEF.SortKey<RawSecretEntry, Long> version = new RSEF.SortKey(2);
    public static RSEF.Attribute<RawSecretEntry, State> state = new RSEF.Attribute(3);
    public static RSEF.OptionalAttribute<RawSecretEntry, ZonedDateTime> notBefore = new RSEF.OptionalAttribute(4);
    public static RSEF.OptionalAttribute<RawSecretEntry, ZonedDateTime> notAfter = new RSEF.OptionalAttribute(5);
    public static Converters converters = new Converters(new SecretIdentifierConverter(), new LongConverter(), new StringConverter(), new StateConverter(), new ByteArrayConverter(), new ZonedDateTimeConverter());

    public static RSEF.AttributeCondition active() {
        ZonedDateTime now = FormattedTimestamp.now();
        return state.eq(State.ENABLED).AND(notBefore.isNotPresent().OR(notBefore.get().le(now))).AND(notAfter.isNotPresent().OR(notAfter.get().ge(now)));
    }

    public static RSEF.AttributeCondition disabled() {
        ZonedDateTime now = FormattedTimestamp.now();
        return state.eq(State.DISABLED).OR(notBefore.isPresent().AND(notBefore.get().lt(now))).AND(notAfter.isPresent().OR(notAfter.get().gt(now)));
    }
}

