/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend;

import com.schibsted.security.strongbox.sdk.exceptions.FieldAccessException;
import com.schibsted.security.strongbox.sdk.exceptions.NoFieldWithPositionException;
import com.schibsted.security.strongbox.sdk.exceptions.UnsupportedTypeException;
import com.schibsted.security.strongbox.sdk.types.RawSecretEntry;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;

public class RSEF {
    public static PartitionKey<RawSecretEntry, String> partitionKey = new PartitionKey(4);
    public static SortKey<RawSecretEntry, String> sortKey = new SortKey(5);
    private static Map<Class, Map<Integer, String>> map = new HashMap<Class, Map<Integer, String>>();

    public static <T> AttributeCondition NOT(AttributeCondition condition) {
        return new NotOperator((ParsedAttributeCondition)((Object)condition));
    }

    private static <S, T> boolean exists(TypedOptionalAttributeReference<T> ref, S entry) {
        String fieldName = RSEF.getFieldName(entry, ref.position);
        try {
            Optional value = (Optional)entry.getClass().getField(fieldName).get(entry);
            return value.isPresent();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new FieldAccessException(fieldName, entry.getClass().getName(), e);
        }
    }

    private static <T extends Comparable<? super T>> boolean compareTo(T l, T r, BinaryOpType binaryOpType) {
        if (l != null && r != null) {
            switch (binaryOpType) {
                case EQ: {
                    return l.compareTo(r) == 0;
                }
                case GE: {
                    return l.compareTo(r) >= 0;
                }
                case GT: {
                    return l.compareTo(r) > 0;
                }
                case LE: {
                    return l.compareTo(r) <= 0;
                }
                case LT: {
                    return l.compareTo(r) < 0;
                }
                case NE: {
                    return l.compareTo(r) != 0;
                }
            }
            throw new UnsupportedTypeException(binaryOpType.name());
        }
        return false;
    }

    private static <S> String getFieldName(S entry, int annotationPosition) {
        String fieldName;
        Map<Integer, String> classMappings = map.get(entry.getClass());
        if (classMappings == null) {
            Field[] fields;
            classMappings = new HashMap<Integer, String>();
            for (Field field : fields = entry.getClass().getDeclaredFields()) {
                int position;
                com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.Attribute[] attributes = (com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.Attribute[])field.getAnnotationsByType(com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.Attribute.class);
                com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.PartitionKey[] partitionKey = (com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.PartitionKey[])field.getAnnotationsByType(com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.PartitionKey.class);
                com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.SortKey[] sortKey = (com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.SortKey[])field.getAnnotationsByType(com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.SortKey.class);
                if (attributes.length > 0) {
                    position = attributes[0].position();
                    classMappings.put(position, field.getName());
                }
                if (partitionKey.length > 0) {
                    position = partitionKey[0].position();
                    classMappings.put(position, field.getName());
                }
                if (sortKey.length <= 0) continue;
                position = sortKey[0].position();
                classMappings.put(position, field.getName());
            }
            map.put(entry.getClass(), classMappings);
        }
        if ((fieldName = classMappings.get(annotationPosition)) != null) {
            return fieldName;
        }
        throw new NoFieldWithPositionException(annotationPosition, entry.getClass().getName());
    }

    private static <S, T> T extract(TypedTerm<T> term, S t) {
        if (term instanceof TypedLiteral) {
            return ((TypedLiteral)term).value;
        }
        String fieldName = "";
        try {
            if (term instanceof TypedAttributeReference) {
                TypedAttributeReference ref = (TypedAttributeReference)term;
                fieldName = RSEF.getFieldName(t, ref.position);
                return (T)t.getClass().getField(fieldName).get(t);
            }
            if (term instanceof TypedPartitionKeyReference) {
                TypedPartitionKeyReference ref = (TypedPartitionKeyReference)term;
                fieldName = RSEF.getFieldName(t, ref.position);
                return (T)t.getClass().getField(fieldName).get(t);
            }
            if (term instanceof TypedSortKeyReference) {
                TypedSortKeyReference ref = (TypedSortKeyReference)term;
                fieldName = RSEF.getFieldName(t, ref.position);
                return (T)t.getClass().getField(fieldName).get(t);
            }
            if (term instanceof TypedOptionalAttributeReference) {
                TypedOptionalAttributeReference ref = (TypedOptionalAttributeReference)term;
                fieldName = RSEF.getFieldName(t, ref.position);
                Optional v = (Optional)t.getClass().getField(fieldName).get(t);
                return v.isPresent() ? (T)v.get() : null;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new FieldAccessException(fieldName, t.getClass().getName(), e);
        }
        throw new UnsupportedTypeException(term.getClass().getName());
    }

    public static class OptionalAttribute<S, T extends Comparable<? super T>> {
        public TypedOptionalAttributeReference<T> variable;

        public OptionalAttribute(int position) {
            this.variable = new TypedOptionalAttributeReference(position);
        }

        public Attribute<S, T> get() {
            return new Attribute(this.variable);
        }

        public AttributeCondition isPresent() {
            return new ExistsOperator(this.variable);
        }

        public AttributeCondition isNotPresent() {
            return new NotExistsOperator(this.variable);
        }
    }

    public static class Attribute<S, T extends Comparable<? super T>> {
        public TypedTerm<T> reference;

        public Attribute(int position) {
            this.reference = new TypedAttributeReference(position);
        }

        public Attribute(TypedTerm<T> term) {
            this.reference = term;
        }

        public AttributeCondition eq(Attribute<S, T> other) {
            return new ComparisonOperator(this.reference, other.reference, BinaryOpType.EQ);
        }

        public AttributeCondition eq(T other) {
            return new ComparisonOperator(this.reference, new TypedLiteral<T>(other), BinaryOpType.EQ);
        }

        public AttributeCondition ge(Attribute<S, T> other) {
            return new ComparisonOperator(this.reference, other.reference, BinaryOpType.GE);
        }

        public AttributeCondition ge(T other) {
            return new ComparisonOperator(this.reference, new TypedLiteral<T>(other), BinaryOpType.GE);
        }

        public AttributeCondition gt(Attribute<S, T> other) {
            return new ComparisonOperator(this.reference, other.reference, BinaryOpType.GT);
        }

        public AttributeCondition gt(T other) {
            return new ComparisonOperator(this.reference, new TypedLiteral<T>(other), BinaryOpType.GT);
        }

        public AttributeCondition le(Attribute<S, T> other) {
            return new ComparisonOperator(this.reference, other.reference, BinaryOpType.LE);
        }

        public AttributeCondition le(T other) {
            return new ComparisonOperator(this.reference, new TypedLiteral<T>(other), BinaryOpType.LE);
        }

        public AttributeCondition lt(Attribute<S, T> other) {
            return new ComparisonOperator(this.reference, other.reference, BinaryOpType.LT);
        }

        public AttributeCondition lt(T other) {
            return new ComparisonOperator(this.reference, new TypedLiteral<T>(other), BinaryOpType.LT);
        }

        public AttributeCondition ne(Attribute<S, T> other) {
            return new ComparisonOperator(this.reference, other.reference, BinaryOpType.NE);
        }

        public void between(T lower, T upper) {
            throw new UnsupportedOperationException("Method not implemented");
        }

        public void in(T ... args) {
            throw new UnsupportedOperationException("Method not implemented");
        }

        public AttributeCondition begins_with(String substring) {
            throw new UnsupportedOperationException("Method not implemented");
        }

        public AttributeCondition attribute_type(String stringTypeEnum) {
            throw new UnsupportedOperationException("Method not implemented");
        }

        public AttributeCondition contains(String stringTypeEnum) {
            throw new UnsupportedOperationException("Method not implemented");
        }

        public void size() {
            throw new UnsupportedOperationException("Method not implemented");
        }
    }

    public static class SortKey<S, T extends Comparable<? super T>> {
        public TypedSortKeyReference<T> reference;

        public SortKey(int position) {
            this.reference = new TypedSortKeyReference(position);
        }

        public SortKeyComparisonOperator<S, T> eq(T other) {
            return new SortKeyComparisonOperator(this.reference, new TypedLiteral<T>(other), BinaryOpType.EQ);
        }

        public SortKeyComparisonOperator<S, T> ge(T other) {
            return new SortKeyComparisonOperator(this.reference, new TypedLiteral<T>(other), BinaryOpType.GE);
        }

        public SortKeyComparisonOperator<S, T> gt(T other) {
            return new SortKeyComparisonOperator(this.reference, new TypedLiteral<T>(other), BinaryOpType.GT);
        }

        public SortKeyComparisonOperator<S, T> le(T other) {
            return new SortKeyComparisonOperator(this.reference, new TypedLiteral<T>(other), BinaryOpType.LE);
        }

        public SortKeyComparisonOperator<S, T> lt(T other) {
            return new SortKeyComparisonOperator(this.reference, new TypedLiteral<T>(other), BinaryOpType.LT);
        }
    }

    public static class PartitionKey<S, T> {
        public TypedPartitionKeyReference<T> reference;

        public PartitionKey(int position) {
            this.reference = new TypedPartitionKeyReference(position);
        }

        public PartitionKeyEqualityOperator<S, T> eq(T other) {
            return new PartitionKeyEqualityOperator(this.reference, new TypedLiteral<T>(other));
        }
    }

    public static class ComparisonOperator<S, T extends Comparable<? super T>>
    extends AttributeCondition
    implements ParsedAttributeCondition<S> {
        public TypedTerm<T> left;
        public TypedTerm<T> right;
        public BinaryOpType binaryOpType;

        ComparisonOperator(TypedTerm<T> left, TypedTerm<T> right, BinaryOpType binaryOpType) {
            this.left = left;
            this.right = right;
            this.binaryOpType = binaryOpType;
        }

        @Override
        public boolean evaluate(S entry) {
            Comparable l = (Comparable)RSEF.extract(this.left, entry);
            Comparable r = (Comparable)RSEF.extract(this.right, entry);
            return RSEF.compareTo(l, r, this.binaryOpType);
        }
    }

    public static class NotExistsOperator<S, T>
    extends AttributeCondition
    implements ParsedAttributeCondition<S> {
        public final TypedOptionalAttributeReference<T> reference;

        public NotExistsOperator(TypedOptionalAttributeReference<T> reference) {
            this.reference = reference;
        }

        @Override
        public boolean evaluate(S entry) {
            return !RSEF.exists(this.reference, entry);
        }
    }

    public static class ExistsOperator<S, T>
    extends AttributeCondition
    implements ParsedAttributeCondition<S> {
        public final TypedOptionalAttributeReference<T> reference;

        public ExistsOperator(TypedOptionalAttributeReference<T> reference) {
            this.reference = reference;
        }

        @Override
        public boolean evaluate(S entry) {
            return RSEF.exists(this.reference, entry);
        }
    }

    public static class NotOperator<S>
    extends AttributeCondition
    implements ParsedAttributeCondition<S> {
        public final ParsedAttributeCondition<S> left;

        public NotOperator(ParsedAttributeCondition<S> left) {
            this.left = left;
        }

        @Override
        public boolean evaluate(S entry) {
            return !this.left.evaluate(entry);
        }
    }

    public static class OrOperator<S>
    extends AttributeCondition
    implements ParsedAttributeCondition<S> {
        public final ParsedAttributeCondition<S> left;
        public final ParsedAttributeCondition<S> right;

        public OrOperator(ParsedAttributeCondition<S> left, ParsedAttributeCondition<S> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean evaluate(S entry) {
            return this.left.evaluate(entry) | this.right.evaluate(entry);
        }
    }

    public static class AndOperator<S>
    extends AttributeCondition
    implements ParsedAttributeCondition<S> {
        public final ParsedAttributeCondition<S> left;
        public final ParsedAttributeCondition<S> right;

        public AndOperator(ParsedAttributeCondition<S> right, ParsedAttributeCondition<S> left) {
            this.right = right;
            this.left = left;
        }

        @Override
        public boolean evaluate(S entry) {
            return this.left.evaluate(entry) & this.right.evaluate(entry);
        }
    }

    public static interface ParsedKeyCondition<S> {
        public boolean evaluate(S var1);
    }

    public static interface ParsedAttributeCondition<S> {
        public boolean evaluate(S var1);
    }

    public static class TypedOptionalAttributeReference<T>
    extends TypedTerm<T> {
        public final Integer position;

        public TypedOptionalAttributeReference(int position) {
            this.position = position;
        }
    }

    public static class TypedPartitionKeyReference<T>
    extends TypedTerm<T> {
        public final Integer position;

        public TypedPartitionKeyReference(int position) {
            this.position = position;
        }
    }

    public static class TypedSortKeyReference<T>
    extends TypedTerm<T> {
        public final Integer position;

        public TypedSortKeyReference(int position) {
            this.position = position;
        }
    }

    public static class TypedAttributeReference<T>
    extends TypedTerm<T> {
        public final Integer position;

        public TypedAttributeReference(int position) {
            this.position = position;
        }
    }

    public static class TypedLiteral<T>
    extends TypedTerm<T> {
        public final T value;

        public TypedLiteral(T value) {
            this.value = value;
        }
    }

    public static abstract class TypedTerm<T> {
    }

    public static class NOT
    extends AttributeCondition {
        public AttributeCondition condition;

        public NOT(AttributeCondition condition) {
            this.condition = condition;
        }
    }

    public static enum BinaryOpType {
        EQ,
        GE,
        GT,
        LE,
        LT,
        NE;

    }

    public static abstract class Term {
    }

    public static class PartitionKeyEqualityOperator<S, T>
    extends KeyCondition
    implements ParsedKeyCondition<S> {
        public TypedPartitionKeyReference<T> left;
        public TypedLiteral<T> right;

        public PartitionKeyEqualityOperator(TypedPartitionKeyReference<T> left, TypedLiteral<T> right) {
            this.left = left;
            this.right = right;
        }

        public KeyCondition AND(SortKeyComparisonOperator<S, ?> other) {
            return new KeyAND<S>(this, other);
        }

        @Override
        public boolean evaluate(S entry) {
            Object l = RSEF.extract(this.left, entry);
            Object r = RSEF.extract(this.right, entry);
            return l.equals(r);
        }
    }

    public static class SortKeyComparisonOperator<S, T extends Comparable<? super T>>
    extends SortKeyCondition
    implements ParsedKeyCondition<S> {
        public TypedTerm<T> left;
        public TypedTerm<T> right;
        public BinaryOpType binaryOpType;

        public SortKeyComparisonOperator(TypedTerm<T> left, TypedTerm<T> right, BinaryOpType binaryOpType) {
            this.left = left;
            this.right = right;
            this.binaryOpType = binaryOpType;
        }

        @Override
        public boolean evaluate(S entry) {
            Comparable l = (Comparable)RSEF.extract(this.left, entry);
            Comparable r = (Comparable)RSEF.extract(this.right, entry);
            return RSEF.compareTo(l, r, this.binaryOpType);
        }
    }

    public static class KeyAND<S>
    extends KeyCondition
    implements ParsedKeyCondition<S> {
        public PartitionKeyEqualityOperator<S, ?> left;
        public SortKeyComparisonOperator<S, ?> right;

        public KeyAND(PartitionKeyEqualityOperator<S, ?> left, SortKeyComparisonOperator<S, ?> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean evaluate(S entry) {
            return this.left.evaluate(entry) & this.right.evaluate(entry);
        }
    }

    public static abstract class KeyCondition<S> {
    }

    public static abstract class SortKeyCondition {
    }

    public static enum LogicalOperatorToken {
        OR,
        AND;

    }

    public static class CompositeAttributeCondition
    extends AttributeCondition {
        public LinkedList<AttributeCondition> conditionals = new LinkedList();
        public LinkedList<LogicalOperatorToken> logicalOperatorTokens = new LinkedList();

        CompositeAttributeCondition(AttributeCondition c) {
            this.conditionals.add(c);
        }

        @Override
        public AttributeCondition OR(AttributeCondition other) {
            this.conditionals.add(other);
            this.logicalOperatorTokens.add(LogicalOperatorToken.OR);
            return this;
        }

        @Override
        public AttributeCondition AND(AttributeCondition other) {
            this.conditionals.add(other);
            this.logicalOperatorTokens.add(LogicalOperatorToken.AND);
            return this;
        }
    }

    public static abstract class AttributeCondition {
        public AttributeCondition OR(AttributeCondition other) {
            CompositeAttributeCondition composite = new CompositeAttributeCondition(this);
            return composite.OR(other);
        }

        public AttributeCondition AND(AttributeCondition other) {
            CompositeAttributeCondition composite = new CompositeAttributeCondition(this);
            return composite.AND(other);
        }
    }
}

