/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.srn;

import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.exceptions.InvalidResourceName;
import com.schibsted.security.strongbox.sdk.internal.srn.SecretsGroupSRN;
import com.schibsted.security.strongbox.sdk.types.Region;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;

public class SecretSRN
extends SecretsGroupSRN {
    public final SecretIdentifier secretIdentifier;
    private static final String RESOURCE_PREFIX = "secret";

    public SecretSRN(String account, SecretsGroupIdentifier groupIdentifier, SecretIdentifier secretIdentifier) {
        super(account, groupIdentifier);
        this.secretIdentifier = secretIdentifier;
    }

    @Override
    public String toString() {
        return this.toSrn();
    }

    @Override
    public String toSrn() {
        return String.format("srn:aws:strongbox:%s:%s:%s/%s/%s", this.groupIdentifier.region.getName(), this.account, RESOURCE_PREFIX, this.groupIdentifier.name.replace('.', '/'), this.secretIdentifier.name);
    }

    public static SecretSRN fromSrn(String srn) {
        String[] parts = srn.split(":");
        if (!(parts[0].equals("srn") && parts[1].equals("aws") && parts[2].equals("strongbox") && parts.length == 6)) {
            throw new InvalidResourceName(srn, "An SRN should start with 'srn:aws:sm' and have 6 parts");
        }
        Region region = Region.fromName(parts[3]);
        String account = parts[4];
        String[] suffix = parts[5].split("/");
        if (!suffix[0].equals(RESOURCE_PREFIX)) {
            throw new InvalidResourceName(srn, "Resource name part of SRN should start with secret");
        }
        String secretsGroupName = parts[5].substring(RESOURCE_PREFIX.length() + 1, parts[5].lastIndexOf(47)).replace("/", ".");
        String secretName = suffix[suffix.length - 1];
        return new SecretSRN(account, new SecretsGroupIdentifier(region, secretsGroupName), new SecretIdentifier(secretName));
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.account, this.groupIdentifier, this.secretIdentifier});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SecretSRN) {
            SecretSRN other = (SecretSRN)obj;
            return Objects.equal((Object)this.account, (Object)other.account) && Objects.equal((Object)this.groupIdentifier, (Object)other.groupIdentifier) && Objects.equal((Object)this.secretIdentifier, (Object)other.secretIdentifier);
        }
        return false;
    }
}

