/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.types.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.schibsted.security.strongbox.sdk.exceptions.ParseException;
import com.schibsted.security.strongbox.sdk.exceptions.SerializationException;
import com.schibsted.security.strongbox.sdk.internal.json.StrongboxModule;
import com.schibsted.security.strongbox.sdk.internal.types.config.UserConfig;
import com.schibsted.security.strongbox.sdk.internal.types.config.UserConfigPayload;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class FileUserConfig
extends UserConfig {
    private File configFile;
    private static ObjectMapper objectMapper = new ObjectMapper().registerModules(new Module[]{new Jdk8Module(), new StrongboxModule()});

    public FileUserConfig(File configFile) {
        super(FileUserConfig.loadLocalFiles(configFile));
        this.configFile = configFile;
    }

    private static Map<SecretsGroupIdentifier, File> loadLocalFiles(File file) {
        try {
            if (file.exists()) {
                UserConfigPayload entry = (UserConfigPayload)objectMapper.readValue(file, UserConfigPayload.class);
                return entry.localFiles.stream().collect(Collectors.toMap(e -> e.group, e -> new File(e.path)));
            }
            return new HashMap<SecretsGroupIdentifier, File>();
        }
        catch (IOException e2) {
            throw new ParseException("Failed to load file", e2);
        }
    }

    @Override
    public Optional<File> getLocalFilePath(SecretsGroupIdentifier group) {
        return Optional.ofNullable(this.localFiles.get(group));
    }

    @Override
    public void addLocalFilePath(SecretsGroupIdentifier group, File path) {
        this.checkUniqueGroup(group);
        this.checkUniqueFilePath(path);
        this.localFiles.put(group, path);
        this.persist();
    }

    @Override
    public void updateLocalFilePath(SecretsGroupIdentifier group, File path) {
        this.checkUniqueFilePath(path);
        this.localFiles.put(group, path);
        this.persist();
    }

    private void persist() {
        try {
            if (!this.configFile.exists()) {
                this.configFile.getParentFile().mkdirs();
            }
            UserConfigPayload payload = new UserConfigPayload(this);
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(this.configFile, (Object)payload);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to serialize to file", e);
        }
    }

    @Override
    public void removeLocalFilePath(SecretsGroupIdentifier group) {
        this.localFiles.remove(group);
        this.persist();
    }
}

