/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.exceptions.ParseException;
import com.schibsted.security.strongbox.sdk.exceptions.SerializationException;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShred;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShredder;
import com.schibsted.security.strongbox.sdk.internal.json.StrongboxModule;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.Attribute;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.PartitionKey;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.SortKey;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;
import com.schibsted.security.strongbox.sdk.types.State;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Optional;

public final class RawSecretEntry
implements BestEffortShred {
    @PartitionKey(position=1, padding=128)
    @JsonProperty(value="secretIdentifier")
    public SecretIdentifier secretIdentifier;
    @SortKey(position=2)
    @JsonProperty(value="version")
    public Long version;
    @Attribute(position=3)
    @JsonProperty(value="state")
    public State state;
    @Attribute(position=4)
    @JsonProperty(value="notBefore")
    public Optional<ZonedDateTime> notBefore = Optional.empty();
    @Attribute(position=5)
    @JsonProperty(value="notAfter")
    public Optional<ZonedDateTime> notAfter = Optional.empty();
    @Attribute(position=6)
    @JsonProperty(value="encryptedPayload")
    public byte[] encryptedPayload;
    private static ObjectMapper objectMapper = new ObjectMapper().registerModules(new Module[]{new Jdk8Module(), new StrongboxModule()});

    @Deprecated
    public RawSecretEntry() {
    }

    public RawSecretEntry(@JsonProperty(value="secretIdentifier") SecretIdentifier secretIdentifier, @JsonProperty(value="version") long version, @JsonProperty(value="state") State state, @JsonProperty(value="notBefore") Optional<ZonedDateTime> notBefore, @JsonProperty(value="notAfter") Optional<ZonedDateTime> notAfter, @JsonProperty(value="encryptedPayload") byte[] encryptedPayload) {
        this.secretIdentifier = secretIdentifier;
        this.version = version;
        this.state = state;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.encryptedPayload = encryptedPayload;
    }

    public String toJsonBlob() {
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Failed to serialize secret entry to JSON blob", e);
        }
    }

    public static RawSecretEntry fromJsonBlob(String jsonBlob) {
        try {
            return (RawSecretEntry)objectMapper.readValue(jsonBlob, RawSecretEntry.class);
        }
        catch (IOException e) {
            throw new ParseException("Failed to deserialize secret entry from JSON blob", e);
        }
    }

    public byte[] sha1OfEncryptionPayload() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(this.encryptedPayload);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to compute sha1 of encryption payload", e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("secretIdentifier", (Object)this.secretIdentifier).add("version", (Object)this.version).add("state", (Object)this.state).add("notBefore", this.notBefore).add("notAfter", this.notAfter).add("encryptedPayload", (Object)this.encryptedPayload).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.secretIdentifier, this.version, this.state, this.notBefore, this.notAfter, this.encryptedPayload});
    }

    public boolean equals(Object obj) {
        if (obj instanceof RawSecretEntry) {
            RawSecretEntry other = (RawSecretEntry)obj;
            return Objects.equal((Object)this.secretIdentifier, (Object)other.secretIdentifier) && Objects.equal((Object)this.version, (Object)other.version) && Objects.equal((Object)((Object)this.state), (Object)((Object)other.state)) && Objects.equal(this.notBefore, other.notBefore) && Objects.equal(this.notAfter, other.notAfter) && Arrays.equals(this.encryptedPayload, other.encryptedPayload);
        }
        return false;
    }

    @Override
    public void bestEffortShred() {
        BestEffortShredder.shred(this.encryptedPayload);
        this.secretIdentifier = null;
        this.version = 0L;
        this.state = State.ENABLED;
        this.notBefore = Optional.empty();
        this.notAfter = Optional.empty();
    }
}

