/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.internal.converter.Encoder;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShred;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShredder;
import com.schibsted.security.strongbox.sdk.types.Encoding;
import com.schibsted.security.strongbox.sdk.types.SecretType;
import java.util.Arrays;

public final class SecretValue
implements BestEffortShred {
    private static final int MAX_LENGTH = 50000;
    private byte[] secretValue;
    public final SecretType type;
    public final Encoding encoding;

    public SecretValue(byte[] secretValue, Encoding encoding, SecretType type) {
        if (secretValue.length == 0) {
            throw new IllegalArgumentException("SecretValue can't be empty");
        }
        if (secretValue.length > 50000) {
            throw new IllegalArgumentException(String.format("SecretValue can at most be %d bytes", 50000));
        }
        this.secretValue = secretValue;
        this.encoding = encoding;
        this.type = type;
    }

    public SecretValue(byte[] secretValue, SecretType type) {
        this(secretValue, Encoding.BINARY, type);
    }

    public SecretValue(String secretValue, SecretType type) {
        this(Encoder.asUTF8(secretValue), Encoding.UTF8, type);
    }

    public byte[] asByteArray() {
        return this.secretValue;
    }

    public String asString() {
        return Encoder.fromUTF8(this.secretValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("secretEncoding", (Object)this.encoding).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.secretValue, this.type, this.encoding});
    }

    public boolean equals(Object obj) {
        if (obj instanceof SecretValue) {
            SecretValue other = (SecretValue)obj;
            return Arrays.equals(this.secretValue, other.asByteArray()) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)((Object)this.encoding), (Object)((Object)other.encoding));
        }
        return false;
    }

    @Override
    public void bestEffortShred() {
        BestEffortShredder.shred(this.secretValue);
    }
}

