/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.types.Region;
import java.util.regex.Pattern;

public final class SecretsGroupIdentifier
implements Comparable<SecretsGroupIdentifier> {
    @JsonProperty(value="region")
    public final Region region;
    @JsonProperty(value="name")
    public final String name;
    private static final int NAME_MIN_LENGTH = 3;
    private static final int NAME_MAX_LENGTH = 64;
    private static final String NAME_REGEX = "^[a-z][a-z0-9]*(\\.[a-z][a-z0-9]*)*$";
    private static Pattern pattern = Pattern.compile("^[a-z][a-z0-9]*(\\.[a-z][a-z0-9]*)*$");

    public SecretsGroupIdentifier(@JsonProperty(value="region") Region region, @JsonProperty(value="name") String name) {
        if (name.length() < 3) {
            throw new IllegalArgumentException(String.format("The group name '%s' must be at least %d characters long", name, 3));
        }
        if (name.length() > 64) {
            throw new IllegalArgumentException(String.format("The group name '%s' can at most be %d characters long", name, 64));
        }
        if (!pattern.matcher(name).find()) {
            throw new IllegalArgumentException(String.format("The group name '%s' must match the regular expression '%s'", name, NAME_REGEX));
        }
        this.region = region;
        this.name = name;
    }

    public String toString() {
        return String.format("%s [%s]", this.name, this.region.getName());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.region});
    }

    public boolean equals(Object obj) {
        if (obj instanceof SecretsGroupIdentifier) {
            SecretsGroupIdentifier other = (SecretsGroupIdentifier)obj;
            return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)((Object)this.region), (Object)((Object)other.region));
        }
        return false;
    }

    @Override
    public int compareTo(SecretsGroupIdentifier o) {
        if (this.region.compareTo(o.region) == 0) {
            return this.name.compareTo(o.name);
        }
        return this.region.compareTo(o.region);
    }
}

