/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Joiner;
import com.schibsted.security.strongbox.sdk.internal.json.StateDeserializer;
import com.schibsted.security.strongbox.sdk.internal.json.StateSerializer;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=StateSerializer.class)
@JsonDeserialize(using=StateDeserializer.class)
public enum State {
    COMPROMISED("compromised", 0),
    DISABLED("disabled", 1),
    ENABLED("enabled", 2);

    static Map<String, State> stateMap;
    static Map<Byte, State> valueMap;
    private final String name;
    private final byte value;

    private State(String name, byte value) {
        this.name = name;
        this.value = value;
    }

    public static State fromString(String state) {
        State s = stateMap.get(state);
        if (s == null) {
            throw new IllegalArgumentException(String.format("Unrecognized state '%s', expected one of {%s}", state, Joiner.on((String)", ").join(stateMap.keySet())));
        }
        return s;
    }

    public String toString() {
        return this.name;
    }

    public byte asByte() {
        return this.value;
    }

    public static State fromByte(byte value) {
        return valueMap.get(value);
    }

    static {
        stateMap = new HashMap<String, State>();
        valueMap = new HashMap<Byte, State>();
        for (State state : State.values()) {
            stateMap.put(state.name, state);
            valueMap.put(state.value, state);
        }
    }
}

