/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.types.SecretEntry;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;

public class StringSecretEntry {
    public final SecretIdentifier secretIdentifer;
    public final long version;
    public final String value;

    public StringSecretEntry(SecretIdentifier secretIdentifer, long version, String value) {
        this.secretIdentifer = secretIdentifer;
        this.version = version;
        this.value = value;
    }

    public static StringSecretEntry of(SecretEntry secretEntry) {
        return new StringSecretEntry(secretEntry.secretIdentifier, secretEntry.version, secretEntry.secretValue.asString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringSecretEntry that = (StringSecretEntry)o;
        return this.version == that.version && Objects.equal((Object)this.secretIdentifer, (Object)that.secretIdentifer) && Objects.equal((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.secretIdentifer, this.version, this.value});
    }
}

