/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.access;

import java.util.HashMap;
import java.util.Map;

public enum AccessLevel {
    ADMIN("admin"),
    READONLY("readonly");

    static Map<String, AccessLevel> accessLevelMap;
    private final String name;

    private AccessLevel(String name) {
        this.name = name;
    }

    public static AccessLevel fromString(String accessLevel) {
        AccessLevel al = accessLevelMap.get(accessLevel);
        if (al == null) {
            throw new IllegalArgumentException("Unrecognized accessLevel '" + accessLevel + "', expected one of " + accessLevelMap.keySet());
        }
        return al;
    }

    public String toString() {
        return this.name;
    }

    static {
        accessLevelMap = new HashMap<String, AccessLevel>();
        for (AccessLevel accessLevel : AccessLevel.values()) {
            accessLevelMap.put(accessLevel.name, accessLevel);
        }
    }
}

