/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.access;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClientBuilder;
import com.amazonaws.services.identitymanagement.model.AttachGroupPolicyRequest;
import com.amazonaws.services.identitymanagement.model.AttachRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.AttachUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.CreatePolicyRequest;
import com.amazonaws.services.identitymanagement.model.CreatePolicyResult;
import com.amazonaws.services.identitymanagement.model.DeletePolicyRequest;
import com.amazonaws.services.identitymanagement.model.DetachGroupPolicyRequest;
import com.amazonaws.services.identitymanagement.model.DetachRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.DetachUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetPolicyRequest;
import com.amazonaws.services.identitymanagement.model.ListEntitiesForPolicyRequest;
import com.amazonaws.services.identitymanagement.model.ListEntitiesForPolicyResult;
import com.amazonaws.services.identitymanagement.model.ListPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListPoliciesResult;
import com.amazonaws.services.identitymanagement.model.NoSuchEntityException;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import com.schibsted.security.strongbox.sdk.exceptions.DoesNotExistException;
import com.schibsted.security.strongbox.sdk.exceptions.UnsupportedTypeException;
import com.schibsted.security.strongbox.sdk.internal.ClientConfigurationHelper;
import com.schibsted.security.strongbox.sdk.internal.IAMPolicyName;
import com.schibsted.security.strongbox.sdk.internal.RegionResolver;
import com.schibsted.security.strongbox.sdk.internal.access.AccessLevel;
import com.schibsted.security.strongbox.sdk.internal.encryption.KMSEncryptor;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generated.Store;
import com.schibsted.security.strongbox.sdk.types.ClientConfiguration;
import com.schibsted.security.strongbox.sdk.types.Principal;
import com.schibsted.security.strongbox.sdk.types.PrincipalType;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class IAMPolicyManager {
    public static final String PATH_PREFIX = "/strongbox/";
    private final AmazonIdentityManagement client;
    private final AWSCredentialsProvider awsCredentials;
    private final ClientConfiguration clientConfiguration;
    private Optional<String> account = Optional.empty();

    public IAMPolicyManager(AmazonIdentityManagement client, AWSCredentialsProvider awsCredentials, ClientConfiguration clientConfiguration) {
        this.awsCredentials = awsCredentials;
        this.client = client;
        this.clientConfiguration = clientConfiguration;
    }

    public static IAMPolicyManager fromCredentials(AWSCredentialsProvider awsCredentials, ClientConfiguration clientConfiguration) {
        AmazonIdentityManagement client = (AmazonIdentityManagement)((AmazonIdentityManagementClientBuilder)((AmazonIdentityManagementClientBuilder)((AmazonIdentityManagementClientBuilder)AmazonIdentityManagementClientBuilder.standard().withCredentials(awsCredentials)).withClientConfiguration(ClientConfigurationHelper.transformAndVerifyOrThrow(clientConfiguration))).withRegion(RegionResolver.getRegion())).build();
        return new IAMPolicyManager(client, awsCredentials, clientConfiguration);
    }

    public static String getAccount(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        AWSSecurityTokenService client = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(awsCredentialsProvider)).withClientConfiguration(ClientConfigurationHelper.transformAndVerifyOrThrow(clientConfiguration))).withRegion(RegionResolver.getRegion())).build();
        GetCallerIdentityRequest request = new GetCallerIdentityRequest();
        GetCallerIdentityResult result = client.getCallerIdentity(request);
        return result.getAccount();
    }

    public String getAccount() {
        if (!this.account.isPresent()) {
            this.account = Optional.of(IAMPolicyManager.getAccount(this.awsCredentials, this.clientConfiguration));
        }
        return this.account.get();
    }

    public boolean adminPolicyExists(SecretsGroupIdentifier group) {
        return this.policyExists(this.getAdminPolicyArn(group));
    }

    public boolean readOnlyPolicyExists(SecretsGroupIdentifier group) {
        return this.policyExists(this.getReadOnlyArn(group));
    }

    private boolean policyExists(String arn) {
        try {
            GetPolicyRequest request = new GetPolicyRequest();
            request.withPolicyArn(arn);
            this.client.getPolicy(request);
            return true;
        }
        catch (NoSuchEntityException e) {
            return false;
        }
    }

    public String getAdminPolicyArn(SecretsGroupIdentifier group) {
        return this.getArn(group, AccessLevel.ADMIN);
    }

    public String getReadOnlyArn(SecretsGroupIdentifier group) {
        return this.getArn(group, AccessLevel.READONLY);
    }

    public void attachAdmin(SecretsGroupIdentifier group, Principal principal) {
        this.attachPrincipalToPolicy(group, principal, AccessLevel.ADMIN);
    }

    public void attachReadOnly(SecretsGroupIdentifier group, Principal principal) {
        this.attachPrincipalToPolicy(group, principal, AccessLevel.READONLY);
    }

    public void detachAllPrincipals(SecretsGroupIdentifier group) {
        try {
            List<Principal> admins = this.listAttachedAdmin(group);
            admins.forEach(p -> this.detachAdmin(group, (Principal)p));
        }
        catch (DoesNotExistException admins) {
            // empty catch block
        }
        try {
            List<Principal> readonly = this.listAttachedReadOnly(group);
            readonly.forEach(p -> this.detachReadOnly(group, (Principal)p));
        }
        catch (DoesNotExistException doesNotExistException) {
            // empty catch block
        }
    }

    public void detachAdmin(SecretsGroupIdentifier group, Principal principal) {
        this.detachPrincipal(group, principal, AccessLevel.ADMIN);
    }

    public void detachReadOnly(SecretsGroupIdentifier group, Principal principal) {
        this.detachPrincipal(group, principal, AccessLevel.READONLY);
    }

    private void detachPrincipal(SecretsGroupIdentifier group, Principal principal, AccessLevel accessLevel) {
        String policyArn = this.getArn(group, accessLevel);
        switch (principal.type) {
            case ROLE: {
                DetachRolePolicyRequest roleRequest = new DetachRolePolicyRequest();
                roleRequest.withPolicyArn(policyArn).withRoleName(principal.name);
                this.client.detachRolePolicy(roleRequest);
                break;
            }
            case USER: {
                DetachUserPolicyRequest userRequest = new DetachUserPolicyRequest();
                userRequest.withPolicyArn(policyArn).withUserName(principal.name);
                this.client.detachUserPolicy(userRequest);
                break;
            }
            case GROUP: {
                DetachGroupPolicyRequest groupRequest = new DetachGroupPolicyRequest();
                groupRequest.withPolicyArn(policyArn).withGroupName(principal.name);
                this.client.detachGroupPolicy(groupRequest);
                break;
            }
            default: {
                throw new UnsupportedTypeException(principal.type.toString());
            }
        }
    }

    public void attachPrincipalToPolicy(SecretsGroupIdentifier group, Principal principal, AccessLevel accessLevel) {
        String policyArn = this.getArn(group, accessLevel);
        switch (principal.type) {
            case ROLE: {
                AttachRolePolicyRequest roleRequest = new AttachRolePolicyRequest();
                roleRequest.withPolicyArn(policyArn).withRoleName(principal.name);
                this.client.attachRolePolicy(roleRequest);
                break;
            }
            case USER: {
                AttachUserPolicyRequest userRequest = new AttachUserPolicyRequest();
                userRequest.withPolicyArn(policyArn).withUserName(principal.name);
                this.client.attachUserPolicy(userRequest);
                break;
            }
            case GROUP: {
                AttachGroupPolicyRequest groupRequest = new AttachGroupPolicyRequest();
                groupRequest.withPolicyArn(policyArn).withGroupName(principal.name);
                this.client.attachGroupPolicy(groupRequest);
                break;
            }
            default: {
                throw new UnsupportedTypeException(principal.type.toString());
            }
        }
    }

    public List<Principal> listAttachedAdmin(SecretsGroupIdentifier group) {
        return this.listEntities(group, AccessLevel.ADMIN);
    }

    public List<Principal> listAttachedReadOnly(SecretsGroupIdentifier group) {
        return this.listEntities(group, AccessLevel.READONLY);
    }

    private List<Principal> listEntities(SecretsGroupIdentifier group, AccessLevel accessLevel) {
        String arn = this.getArn(group, accessLevel);
        try {
            ListEntitiesForPolicyRequest request = new ListEntitiesForPolicyRequest();
            request.withPolicyArn(arn);
            ListEntitiesForPolicyResult result = this.client.listEntitiesForPolicy(request);
            ArrayList<Principal> all = new ArrayList<Principal>();
            List groups = result.getPolicyGroups().stream().map(g -> new Principal(PrincipalType.GROUP, g.getGroupName())).collect(Collectors.toList());
            List users = result.getPolicyUsers().stream().map(u -> new Principal(PrincipalType.USER, u.getUserName())).collect(Collectors.toList());
            List roles = result.getPolicyRoles().stream().map(r -> new Principal(PrincipalType.ROLE, r.getRoleName())).collect(Collectors.toList());
            all.addAll(groups);
            all.addAll(users);
            all.addAll(roles);
            return all;
        }
        catch (NoSuchEntityException e) {
            throw new DoesNotExistException(String.format("Could not find policy with ARN: '%s'", arn), e);
        }
    }

    public Set<SecretsGroupIdentifier> getSecretsGroupIdentifiers() {
        ListPoliciesRequest request = new ListPoliciesRequest();
        request.setMaxItems(Integer.valueOf(1000));
        request.setPathPrefix(PATH_PREFIX);
        ListPoliciesResult result = this.client.listPolicies(request);
        return result.getPolicies().stream().map(p -> IAMPolicyName.fromString((String)p.getPolicyName()).group).distinct().collect(Collectors.toSet());
    }

    private String getArn(SecretsGroupIdentifier group, AccessLevel accessLevel) {
        IAMPolicyName name = new IAMPolicyName(group, accessLevel);
        return String.format("arn:aws:iam::%s:policy%s%s", this.getAccount(), PATH_PREFIX, name.toString());
    }

    private String storeReadOnlyPolicyString(Store store) {
        Optional<String> policy = store.awsReadOnlyPolicy();
        return policy.isPresent() ? policy.get() : "";
    }

    private String storeAdminPolicyString(Store store) {
        Optional<String> policy = store.awsAdminPolicy();
        return policy.isPresent() ? policy.get() : "";
    }

    public String createAdminPolicy(SecretsGroupIdentifier group, KMSEncryptor kmsEncryptor, Store store) {
        String adminPolicy = "{\n  \"Version\": \"2012-10-17\",\n  \"Statement\": [\n" + kmsEncryptor.awsAdminPolicy().get() + ",\n" + this.storeAdminPolicyString(store) + ",\n" + this.listAllPolicies() + ",\n" + this.getPolicyInfo(group) + ",\n" + this.managePolicies(group) + "\n  ]\n}";
        return this.createPolicy(group, AccessLevel.ADMIN, adminPolicy);
    }

    public String createReadOnlyPolicy(SecretsGroupIdentifier group, KMSEncryptor kmsEncryptor, Store store) {
        String readOnlyPolicy = "{\n  \"Version\": \"2012-10-17\",\n  \"Statement\": [\n" + this.storeReadOnlyPolicyString(store) + ",\n" + kmsEncryptor.awsReadOnlyPolicy().get() + "\n  ]\n}";
        return this.createPolicy(group, AccessLevel.READONLY, readOnlyPolicy);
    }

    private String listAllPolicies() {
        return "    {\n        \"Sid\": \"IAMListAllPolicies\",\n        \"Effect\": \"Allow\",\n        \"Action\": [\n            \"iam:ListPolicies\"\n        ],\n        \"Resource\": \"arn:aws:iam::" + this.getAccount() + ":policy" + PATH_PREFIX + "\"\n    }";
    }

    private String getPolicyInfo(SecretsGroupIdentifier group) {
        return "    {\n        \"Sid\": \"IAMSecretGroupPolicies\",\n        \"Effect\": \"Allow\",\n        \"Action\": [\n            \"iam:ListEntitiesForPolicy\",\n            \"iam:GetPolicy\"\n        ],\n        \"Resource\": [\n            \"" + this.getAdminPolicyArn(group) + "\",\n            \"" + this.getReadOnlyArn(group) + "\"\n        ]\n    }";
    }

    private String managePolicies(SecretsGroupIdentifier group) {
        return "    {\n        \"Sid\": \"IAMManagePolicies\",\n        \"Effect\": \"Allow\",\n        \"Action\": [\n            \"iam:AttachRolePolicy\",\n            \"iam:AttachGroupPolicy\",\n            \"iam:AttachUserPolicy\",\n            \"iam:DetachRolePolicy\",\n            \"iam:DetachGroupPolicy\",\n            \"iam:DetachUserPolicy\"\n        ],\n        \"Resource\": \"*\",\n        \"Condition\": {\n            \"ArnEquals\": {\n                \"iam:PolicyArn\": [\n                    \"" + this.getAdminPolicyArn(group) + "\",\n                    \"" + this.getReadOnlyArn(group) + "\"\n                ]\n            }\n        }\n    }";
    }

    private String createPolicy(SecretsGroupIdentifier group, AccessLevel accessLevel, String policy) {
        IAMPolicyName name = new IAMPolicyName(group, accessLevel);
        String description = "This policy is managed by Strongbox. This policy grants " + accessLevel.toString() + " permissions.";
        CreatePolicyRequest request = new CreatePolicyRequest();
        request.withPolicyName(name.toString()).withDescription(description).withPolicyDocument(policy).withPath(PATH_PREFIX);
        CreatePolicyResult result = this.client.createPolicy(request);
        return result.getPolicy().getArn();
    }

    public void deleteAdminPolicy(SecretsGroupIdentifier group) {
        this.deletePolicy(group, AccessLevel.ADMIN);
    }

    public void deleteReadonlyPolicy(SecretsGroupIdentifier group) {
        this.deletePolicy(group, AccessLevel.READONLY);
    }

    private void deletePolicy(SecretsGroupIdentifier group, AccessLevel accessLevel) {
        String arn = this.getArn(group, accessLevel);
        DeletePolicyRequest request = new DeletePolicyRequest();
        request.withPolicyArn(arn);
        this.client.deletePolicy(request);
    }
}

