/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.config.credentials;

import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.securitytoken.model.AssumedRoleUser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.schibsted.security.strongbox.sdk.internal.config.credentials.SessionCacheSchema;
import com.schibsted.security.strongbox.sdk.types.ProfileIdentifier;
import com.schibsted.security.strongbox.sdk.types.arn.RoleARN;
import java.io.File;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Optional;

public class SessionCache {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final int EXPIRATION_THRESHOLD_IN_SECONDS = 60;
    private final RoleARN roleToAssume;
    private final ProfileIdentifier profile;
    private final File file;

    public SessionCache(ProfileIdentifier profile, RoleARN roleToAssume) {
        this.profile = profile;
        this.roleToAssume = roleToAssume;
        this.file = this.resolveFile();
    }

    public Optional<BasicSessionCredentials> load() {
        if (!this.file.exists()) {
            return Optional.empty();
        }
        try {
            SessionCacheSchema cache = (SessionCacheSchema)objectMapper.readValue(this.file, SessionCacheSchema.class);
            if (ZonedDateTime.now().plusSeconds(60L).isBefore(cache.credentials.getExpiration())) {
                return Optional.of(new BasicSessionCredentials(cache.credentials.accessKeyId, cache.credentials.secretAccessKey, cache.credentials.sessionToken));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to load session cache from '%s'", this.file.getAbsolutePath()), e);
        }
    }

    public void save(AssumedRoleUser assumedRoleUser, BasicSessionCredentials credentials, ZonedDateTime expiration) {
        this.resolveCacheDirectory().mkdirs();
        SessionCacheSchema cache = new SessionCacheSchema(assumedRoleUser.getArn(), assumedRoleUser.getAssumedRoleId(), credentials, expiration);
        try {
            objectMapper.writeValue(this.file, (Object)cache);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to save session cache to '%s'", this.file.getAbsolutePath()), e);
        }
    }

    File resolveFile() {
        return new File(this.resolveCacheDirectory(), this.resolveFileName());
    }

    File resolveCacheDirectory() {
        return new File(System.getProperty("user.home") + "/.aws/cli/cache/");
    }

    String resolveFileName() {
        return String.format("%s--%s.json", this.profile.name, this.roleToAssume.toArn().replace(':', '_').replace('/', '-'));
    }
}

