/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.encryption;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.exceptions.ParseException;
import com.schibsted.security.strongbox.sdk.exceptions.SerializationException;
import com.schibsted.security.strongbox.sdk.internal.converter.Encoder;
import com.schibsted.security.strongbox.sdk.internal.converter.FormattedTimestamp;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShred;
import com.schibsted.security.strongbox.sdk.internal.json.StrongboxModule;
import com.schibsted.security.strongbox.sdk.types.Comment;
import com.schibsted.security.strongbox.sdk.types.Encoding;
import com.schibsted.security.strongbox.sdk.types.SecretType;
import com.schibsted.security.strongbox.sdk.types.SecretValue;
import com.schibsted.security.strongbox.sdk.types.State;
import com.schibsted.security.strongbox.sdk.types.UserAlias;
import com.schibsted.security.strongbox.sdk.types.UserData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Optional;

public class EncryptionPayload
implements BestEffortShred {
    public final SecretValue value;
    public final Optional<UserData> userData;
    public final ZonedDateTime created;
    public final ZonedDateTime modified;
    public final Optional<UserAlias> createdBy;
    public final Optional<UserAlias> modifiedBy;
    public final Optional<Comment> comment;
    private static ObjectMapper objectMapper = new ObjectMapper().registerModules(new Module[]{new Jdk8Module(), new StrongboxModule()});
    private final SecureRandom random;

    @JsonCreator
    public EncryptionPayload(@JsonProperty(value="value") SecretValue value, @JsonProperty(value="userdata") Optional<UserData> userData, @JsonProperty(value="created") ZonedDateTime created, Optional<UserAlias> createdBy, @JsonProperty(value="modified") ZonedDateTime modified, Optional<UserAlias> modifiedBy, @JsonProperty(value="comment") Optional<Comment> comment) {
        this.value = value;
        this.userData = userData;
        this.created = created;
        this.modified = modified;
        this.createdBy = createdBy;
        this.modifiedBy = modifiedBy;
        this.comment = comment;
        try {
            this.random = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to instantiate random number generator", e);
        }
    }

    public static byte[] computeSHA(State state, Optional<ZonedDateTime> notBefore, Optional<ZonedDateTime> notAfter) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(state.asByte());
            messageDigest.update(EncryptionPayload.toByteArray(notBefore));
            messageDigest.update(EncryptionPayload.toByteArray(notAfter));
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SerializationException("Failed to get SHA for encryption payload", e);
        }
    }

    private static byte[] toByteArray(Optional<ZonedDateTime> date) {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        if (date.isPresent()) {
            buffer.put((byte)1);
            buffer.putLong(FormattedTimestamp.epoch(date.get()));
        } else {
            buffer.put((byte)0);
            buffer.putLong(0L);
        }
        return buffer.array();
    }

    public static boolean verifyDataIntegrity(State state, Optional<ZonedDateTime> notBefore, Optional<ZonedDateTime> notAfter, byte[] sha) {
        return Arrays.equals(EncryptionPayload.computeSHA(state, notBefore, notAfter), sha);
    }

    public byte[] toByteArray() {
        byte[] userData = this.extractByteArray(this.userData.map(UserData::asByteArray));
        byte[] comment = this.extractByteArray(this.comment.map(Comment::asByteArray));
        byte[] createdBy = this.extract(this.createdBy.map(a -> a.alias));
        byte[] updatedBy = this.extract(this.modifiedBy.map(a -> a.alias));
        int padding = this.computePadding(userData, comment, createdBy, updatedBy);
        int totalLength = this.computeLength(padding, userData, comment, createdBy, updatedBy);
        ByteBuffer byteBuffer = ByteBuffer.allocate(totalLength);
        byteBuffer.put((byte)1);
        byteBuffer.putLong(FormattedTimestamp.epoch(this.created));
        byteBuffer.putLong(FormattedTimestamp.epoch(this.modified));
        this.putArray(byteBuffer, createdBy);
        this.putArray(byteBuffer, updatedBy);
        byteBuffer.put(this.value.encoding.asByte());
        byteBuffer.put(this.value.type.asByte());
        this.putArray(byteBuffer, this.value.asByteArray());
        this.putArray(byteBuffer, userData);
        this.putArray(byteBuffer, comment);
        this.putArray(byteBuffer, new byte[padding]);
        return byteBuffer.array();
    }

    public static EncryptionPayload fromByteArray(byte[] payload) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        byte version = byteBuffer.get();
        if (version != 1) {
            throw new IllegalStateException(String.format("Expected version 1, got %d", version));
        }
        ZonedDateTime created = FormattedTimestamp.fromEpoch(byteBuffer.getLong());
        ZonedDateTime modified = FormattedTimestamp.fromEpoch(byteBuffer.getLong());
        Optional<UserAlias> createdBy = EncryptionPayload.readOptionalString(byteBuffer).map(UserAlias::new);
        Optional<UserAlias> modifiedBy = EncryptionPayload.readOptionalString(byteBuffer).map(UserAlias::new);
        Encoding encoding = Encoding.fromByte(byteBuffer.get());
        SecretType secretType = SecretType.fromByte(byteBuffer.get());
        SecretValue value = new SecretValue(EncryptionPayload.readArray(byteBuffer), encoding, secretType);
        Optional<UserData> userData = EncryptionPayload.readUserData(byteBuffer);
        Optional<Comment> comment = EncryptionPayload.readComment(byteBuffer);
        return new EncryptionPayload(value, userData, created, createdBy, modified, modifiedBy, comment);
    }

    private static byte[] readArray(ByteBuffer byteBuffer) {
        int length = byteBuffer.getInt();
        byte[] array = new byte[length];
        byteBuffer.get(array, 0, length);
        return array;
    }

    private void putArray(ByteBuffer byteBuffer, byte[] value) {
        byteBuffer.putInt(value.length);
        byteBuffer.put(value);
    }

    private static Optional<UserData> readUserData(ByteBuffer byteBuffer) {
        byte[] value = EncryptionPayload.readArray(byteBuffer);
        return value.length == 0 ? Optional.empty() : Optional.of(new UserData(value));
    }

    private static Optional<Comment> readComment(ByteBuffer byteBuffer) {
        byte[] value = EncryptionPayload.readArray(byteBuffer);
        return value.length == 0 ? Optional.empty() : Optional.of(new Comment(value));
    }

    private static Optional<String> readOptionalString(ByteBuffer byteBuffer) {
        byte[] value = EncryptionPayload.readArray(byteBuffer);
        return EncryptionPayload.extractOptionalString(value);
    }

    private byte[] extract(Optional<String> optionalString) {
        return optionalString.isPresent() ? Encoder.asUTF8(optionalString.get()) : new byte[]{};
    }

    private byte[] extractByteArray(Optional<byte[]> optionalByteArray) {
        return optionalByteArray.isPresent() ? optionalByteArray.get() : new byte[]{};
    }

    private static Optional<String> extractOptionalString(byte[] value) {
        return value.length == 0 ? Optional.empty() : Optional.of(Encoder.fromUTF8(value));
    }

    private int computePadding(byte[] userData, byte[] comment, byte[] createdBy, byte[] updatedBy) {
        int padding = 0;
        padding += this.moduloPadding(this.value.asByteArray().length, 1000, 50000);
        padding += this.randomPadding(userData.length, 50000, 1000);
        padding += this.absolutePadding(comment.length, 1000);
        padding += this.absolutePadding(createdBy.length, 32);
        return padding += this.absolutePadding(updatedBy.length, 32);
    }

    int randomPadding(int actualLength, int maxLength, int maxPadding) {
        this.throwIfAboveMax(actualLength, maxLength);
        return this.random.nextInt(maxPadding);
    }

    int moduloPadding(int val, int mod, int max) {
        this.throwIfAboveMax(val, max);
        return mod - val % mod;
    }

    int absolutePadding(int val, int max) {
        this.throwIfAboveMax(val, max);
        return max - val;
    }

    void throwIfAboveMax(int val, int max) {
        if (val > max) {
            throw new IllegalStateException("Field is larger than expected");
        }
    }

    private int computeLength(int padding, byte[] userData, byte[] comment, byte[] createdBy, byte[] updatedBy) {
        return 21 + createdBy.length + 4 + updatedBy.length + 1 + 1 + 4 + this.value.asByteArray().length + 4 + userData.length + 4 + comment.length + 4 + padding;
    }

    public String toJsonBlob() {
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Failed to serialize to JSON blob", e);
        }
    }

    public static EncryptionPayload fromJsonBlob(String jsonBlob) {
        try {
            return (EncryptionPayload)objectMapper.readValue(jsonBlob, EncryptionPayload.class);
        }
        catch (IOException e) {
            throw new ParseException("Failed to deserialize JSON blob", e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("userdata", this.userData).add("created", (Object)this.created).add("modified", (Object)this.modified).add("comment", this.comment).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.created, this.comment});
    }

    public boolean equals(Object obj) {
        if (obj instanceof EncryptionPayload) {
            EncryptionPayload other = (EncryptionPayload)obj;
            return Objects.equal((Object)this.value, (Object)other.value) && Objects.equal(this.userData, other.userData) && Objects.equal((Object)this.created, (Object)other.created) && Objects.equal((Object)this.modified, (Object)other.modified) && Objects.equal(this.comment, other.comment);
        }
        return false;
    }

    @Override
    public void bestEffortShred() {
        this.value.bestEffortShred();
        this.userData.ifPresent(UserData::bestEffortShred);
        this.comment.ifPresent(Comment::bestEffortShred);
    }
}

