/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.encryption;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.kms.model.GenerateRandomRequest;
import com.amazonaws.services.kms.model.GenerateRandomResult;
import com.schibsted.security.strongbox.sdk.internal.ClientConfigurationHelper;
import com.schibsted.security.strongbox.sdk.internal.RegionResolver;
import com.schibsted.security.strongbox.sdk.internal.encryption.RandomGenerator;
import com.schibsted.security.strongbox.sdk.types.ClientConfiguration;

public class KMSRandomGenerator
implements RandomGenerator {
    private final AWSKMS client;

    public KMSRandomGenerator(AWSCredentialsProvider awsCredentials, ClientConfiguration clientConfiguration) {
        this.client = (AWSKMS)((AWSKMSClientBuilder)((AWSKMSClientBuilder)((AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withCredentials(awsCredentials)).withClientConfiguration(ClientConfigurationHelper.transformAndVerifyOrThrow(clientConfiguration))).withRegion(RegionResolver.getRegion())).build();
    }

    public KMSRandomGenerator() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    @Override
    public byte[] generateRandom(Integer numberOfBytes) {
        GenerateRandomRequest request = new GenerateRandomRequest();
        request.withNumberOfBytes(numberOfBytes);
        GenerateRandomResult result = this.client.generateRandom(request);
        return result.getPlaintext().array();
    }
}

