/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.kv4j.generic.backend.dynamodb;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.google.common.collect.Lists;
import com.schibsted.security.strongbox.sdk.exceptions.AlreadyExistsException;
import com.schibsted.security.strongbox.sdk.exceptions.DoesNotExistException;
import com.schibsted.security.strongbox.sdk.exceptions.FieldAccessException;
import com.schibsted.security.strongbox.sdk.exceptions.ParseException;
import com.schibsted.security.strongbox.sdk.exceptions.PotentiallyMaliciousDataException;
import com.schibsted.security.strongbox.sdk.exceptions.UnexpectedStateException;
import com.schibsted.security.strongbox.sdk.internal.RegionLocalResourceName;
import com.schibsted.security.strongbox.sdk.internal.access.IAMPolicyManager;
import com.schibsted.security.strongbox.sdk.internal.converter.Converters;
import com.schibsted.security.strongbox.sdk.internal.converter.Encoder;
import com.schibsted.security.strongbox.sdk.internal.interfaces.ManagedResource;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.GenericStore;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.Attribute;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.PartitionKey;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.SortKey;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.backend.dynamodb.FilterGenerator;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.backend.dynamodb.KeyExpressionGenerator;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.KVStream;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.RSEF;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.SecretEventStream;
import com.schibsted.security.strongbox.sdk.types.ClientConfiguration;
import com.schibsted.security.strongbox.sdk.types.RawSecretEntry;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDynamoDB<Entry, Primary>
implements GenericStore<Entry, Primary>,
ManagedResource,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(GenericDynamoDB.class);
    private static final int SLEEP_TIME = 5000;
    private static final int MAX_RETRIES = 30;
    private AmazonDynamoDB client;
    private AWSCredentialsProvider awsCredentials;
    private ClientConfiguration clientConfiguration;
    private final String tableName;
    private Converters converters;
    private final Region region;
    private final ReadWriteLock readWriteLock;
    private final String SCHEMA_VERSION_FIELD_NAME = "0";
    private final String SCHEMA_VERSION = "1";
    private final String OPTIMISTIC_LOCK_FIELD_NAME = "optimisticLock";
    Class<Entry> clazz;
    Map<Integer, String> attributeMappings = new HashMap<Integer, String>();
    Map<Integer, String> partitionKeyMapping = new HashMap<Integer, String>();
    Integer partitionKeyName;
    Map<Integer, String> sortKeyMapping = new HashMap<Integer, String>();
    Integer sortKeyName;
    private RSEF.PartitionKey<Entry, Primary> partitionKeyRef;

    public GenericDynamoDB(AmazonDynamoDB client, AWSCredentialsProvider awsCredentials, ClientConfiguration clientConfiguration, SecretsGroupIdentifier groupIdentifier, Class<Entry> clazz, Converters converters, ReadWriteLock readWriteLock) {
        this.clazz = clazz;
        this.buildMappings();
        this.converters = converters;
        this.awsCredentials = awsCredentials;
        this.clientConfiguration = clientConfiguration;
        this.client = client;
        this.region = RegionUtils.getRegion((String)groupIdentifier.region.getName());
        this.readWriteLock = readWriteLock;
        RegionLocalResourceName resourceName = new RegionLocalResourceName(groupIdentifier);
        this.tableName = resourceName.toString();
    }

    private void waitForTableToBecomeActive() {
        String tableStatus = "Unknown";
        try {
            for (int retries = 0; retries < 30; ++retries) {
                log.info("Waiting for table to become active...");
                Thread.sleep(5000L);
                DescribeTableResult result = this.client.describeTable(this.tableName);
                tableStatus = result.getTable().getTableStatus();
                if (tableStatus.equals(TableStatus.ACTIVE.toString()) || tableStatus.equals(TableStatus.UPDATING.toString())) {
                    return;
                }
                if (!tableStatus.equals(TableStatus.DELETING.toString())) continue;
                throw new UnexpectedStateException(this.tableName, tableStatus, TableStatus.ACTIVE.toString(), "Table state changed to 'DELETING' before creation was confirmed");
            }
        }
        catch (InterruptedException e) {
            throw new UnexpectedStateException(this.tableName, tableStatus, TableStatus.ACTIVE.toString(), "Error occurred while waiting for DynamoDB table", e);
        }
        throw new UnexpectedStateException(this.tableName, tableStatus, TableStatus.ACTIVE.toString(), "DynamoDB table did not become active before timeout");
    }

    private void waitForTableToFinishDeleting() {
        String tableStatus = "Unknown";
        try {
            for (int retries = 0; retries < 30; ++retries) {
                log.info("Waiting for table to be deleted...");
                Thread.sleep(5000L);
                DescribeTableResult result = this.client.describeTable(this.tableName);
                tableStatus = result.getTable().getTableStatus();
            }
        }
        catch (ResourceNotFoundException e) {
            return;
        }
        catch (InterruptedException e) {
            throw new UnexpectedStateException(this.tableName, tableStatus, "DELETED", "Error occurred while waiting for DynamoDB table", e);
        }
        throw new UnexpectedStateException(this.tableName, tableStatus, "DELETED", "DynamoDB table was not deleted before timeout");
    }

    public CreateTableRequest constructCreateTableRequest() {
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition().withAttributeName(this.partitionKeyName.toString()).withAttributeType("S"));
        attributeDefinitions.add(new AttributeDefinition().withAttributeName(this.sortKeyName.toString()).withAttributeType("N"));
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add(new KeySchemaElement().withAttributeName(this.partitionKeyName.toString()).withKeyType(KeyType.HASH));
        keySchema.add(new KeySchemaElement().withAttributeName(this.sortKeyName.toString()).withKeyType(KeyType.RANGE));
        ProvisionedThroughput provisionedThroughput = new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(1L)).withWriteCapacityUnits(Long.valueOf(1L));
        CreateTableRequest request = new CreateTableRequest().withTableName(this.tableName).withKeySchema(keySchema).withAttributeDefinitions(attributeDefinitions).withProvisionedThroughput(provisionedThroughput);
        return request;
    }

    @Override
    public String create() {
        this.readWriteLock.writeLock().lock();
        try {
            CreateTableResult result = this.client.createTable(this.constructCreateTableRequest());
            this.waitForTableToBecomeActive();
            String string = result.getTableDescription().getTableArn();
            return string;
        }
        catch (ResourceInUseException e) {
            throw new AlreadyExistsException(String.format("There is already a DynamoDB table called '%s'", this.tableName), e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void delete() {
        this.readWriteLock.writeLock().lock();
        try {
            this.client.deleteTable(this.tableName);
            this.waitForTableToFinishDeleting();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public Optional<String> awsAdminPolicy() {
        return Optional.of("    {\n        \"Sid\": \"DynamoDB\",\n        \"Effect\": \"Allow\",\n        \"Action\": [\n            \"dynamodb:*\"\n        ],\n        \"Resource\": \"" + this.getArn() + "\"\n    }");
    }

    @Override
    public Optional<String> awsReadOnlyPolicy() {
        return Optional.of("    {\n        \"Sid\": \"DynamoDB\",\n        \"Effect\": \"Allow\",\n        \"Action\": [\n            \"dynamodb:Query\",\n            \"dynamodb:Scan\"\n        ],\n        \"Resource\": \"" + this.getArn() + "\"\n    }");
    }

    @Override
    public String getArn() {
        return String.format("arn:aws:dynamodb:%s:%s:table/%s", this.region.getName(), IAMPolicyManager.getAccount(this.awsCredentials, this.clientConfiguration), this.tableName);
    }

    @Override
    public boolean exists() {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.describeTable().isPresent();
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private Optional<TableDescription> describeTable() {
        try {
            DescribeTableResult result = this.client.describeTable(this.tableName);
            return Optional.of(result.getTable());
        }
        catch (ResourceNotFoundException e) {
            return Optional.empty();
        }
    }

    private void buildMappings() {
        Field[] fields;
        for (Field field : fields = this.clazz.getDeclaredFields()) {
            int position;
            Attribute[] attributes = (Attribute[])field.getAnnotationsByType(Attribute.class);
            PartitionKey[] partitionKey = (PartitionKey[])field.getAnnotationsByType(PartitionKey.class);
            SortKey[] sortKey = (SortKey[])field.getAnnotationsByType(SortKey.class);
            if (attributes.length > 0) {
                position = attributes[0].position();
                this.attributeMappings.put(position, field.getName());
            }
            if (partitionKey.length > 0) {
                position = partitionKey[0].position();
                this.partitionKeyMapping.put(position, field.getName());
                this.partitionKeyName = position;
                this.partitionKeyRef = new RSEF.PartitionKey(position);
            }
            if (sortKey.length <= 0) continue;
            int name = sortKey[0].position();
            this.sortKeyMapping.put(name, field.getName());
            this.sortKeyName = name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Entry entry) {
        this.readWriteLock.writeLock().lock();
        try {
            Map<String, AttributeValue> keys = this.createKey(entry);
            Map<String, AttributeValueUpdate> attributes = this.createAttributes(entry);
            Map<String, ExpectedAttributeValue> expected = this.expectNotExists();
            try {
                this.executeUpdate(keys, attributes, expected);
            }
            catch (ConditionalCheckFailedException e) {
                throw new AlreadyExistsException("DynamoDB store entry already exists:" + keys.toString());
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Entry entry, Entry existingEntry) {
        this.readWriteLock.writeLock().lock();
        try {
            Map<String, AttributeValue> keys = this.createKey(entry);
            Map<String, AttributeValueUpdate> attributes = this.createAttributes(entry);
            Map<String, ExpectedAttributeValue> expected = this.expectExists(existingEntry);
            try {
                this.executeUpdate(keys, attributes, expected);
            }
            catch (ConditionalCheckFailedException e) {
                throw new DoesNotExistException("Precondition to update entry in DynamoDB failed:" + keys.toString());
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void executeUpdate(Map<String, AttributeValue> keys, Map<String, AttributeValueUpdate> attributes, Map<String, ExpectedAttributeValue> expected) {
        UpdateItemRequest updateEntry = new UpdateItemRequest().withTableName(this.tableName).withKey(keys).withAttributeUpdates(attributes).withExpected(expected);
        this.client.updateItem(updateEntry);
    }

    private Map<String, ExpectedAttributeValue> expectNotExists() {
        HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>();
        expected.put(this.partitionKeyName.toString(), new ExpectedAttributeValue(Boolean.valueOf(false)));
        return expected;
    }

    private Map<String, ExpectedAttributeValue> expectExists(Entry entry) {
        HashMap<String, ExpectedAttributeValue> expected = new HashMap<String, ExpectedAttributeValue>();
        ExpectedAttributeValue expectedAttributeValue = new ExpectedAttributeValue(Boolean.valueOf(true));
        expectedAttributeValue.setValue(new AttributeValue(this.getPartitionKeyValue(entry)));
        expected.put(this.partitionKeyName.toString(), expectedAttributeValue);
        ExpectedAttributeValue expectedSha = new ExpectedAttributeValue(Boolean.valueOf(true));
        expectedSha.setValue(new AttributeValue(this.sha(entry)));
        expected.put("optimisticLock", expectedSha);
        return expected;
    }

    private String sha(Entry entry) {
        RawSecretEntry rse = (RawSecretEntry)entry;
        return Encoder.base64encode(rse.sha1OfEncryptionPayload());
    }

    private Map<String, AttributeValueUpdate> createAttributes(Entry entry) {
        HashMap<String, AttributeValueUpdate> attributes = new HashMap<String, AttributeValueUpdate>();
        attributes.put("0", new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withN("1")));
        attributes.put("optimisticLock", new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withS(this.sha(entry))));
        for (Map.Entry<Integer, String> e : this.attributeMappings.entrySet()) {
            Object value = this.getValue(entry, e.getValue());
            if (value == null) continue;
            attributes.put(e.getKey().toString(), new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(this.getAttribute(value)));
        }
        return attributes;
    }

    private AttributeValue getAttribute(Object value) {
        if (value instanceof String) {
            return new AttributeValue().withS((String)value);
        }
        if (value instanceof Byte || value instanceof Long) {
            return new AttributeValue().withN(value.toString());
        }
        if (value instanceof byte[]) {
            return new AttributeValue().withS(Encoder.base64encode((byte[])value));
        }
        throw new RuntimeException("Failed to recognize type");
    }

    private Map<String, AttributeValue> createKey(Entry entry) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put(this.partitionKeyName.toString(), new AttributeValue().withS(this.getPartitionKeyValue(entry)));
        key.put(this.sortKeyName.toString(), new AttributeValue().withN(this.getSortKeyValue(entry)));
        return key;
    }

    private String getPartitionKeyValue(Entry entry) {
        return this.getValue(entry, this.partitionKeyMapping.get(this.partitionKeyName)).toString();
    }

    private Primary getUnconvertedPartitionKeyValue(Entry entry) {
        Field field = this.getField(entry, this.partitionKeyMapping.get(this.partitionKeyName));
        try {
            return (Primary)field.get(entry);
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException(field.getName(), entry.getClass().getName(), e);
        }
    }

    private String getSortKeyValue(Entry entry) {
        return this.getValue(entry, this.sortKeyMapping.get(this.sortKeyName)).toString();
    }

    private Object getValue(Entry entry, String fieldName) {
        try {
            Field field = this.getField(entry, fieldName);
            return this.converters.toObject(field.get(entry));
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException(fieldName, entry.getClass().getName(), e);
        }
    }

    private Field getField(Entry entry, String fieldName) {
        try {
            return entry.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new FieldAccessException(fieldName, entry.getClass().getName(), e);
        }
    }

    private String getFieldName(String attributeName) {
        if (attributeName.equals(this.partitionKeyName.toString())) {
            return this.partitionKeyMapping.get(this.partitionKeyName);
        }
        if (attributeName.endsWith(this.sortKeyName.toString())) {
            return this.sortKeyMapping.get(this.sortKeyName);
        }
        return this.attributeMappings.get(Integer.valueOf(attributeName));
    }

    @Override
    public void delete(Primary partitionKeyValue) {
        this.readWriteLock.writeLock().lock();
        try {
            this.stream().filter(this.partitionKeyRef.eq(partitionKeyValue)).toJavaStream().forEach(entry -> this.client.deleteItem(this.tableName, this.createKey(entry)));
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public Set<Primary> keySet() {
        this.readWriteLock.readLock().lock();
        try {
            Set set = this.stream().uniquePrimaryKey().toJavaStream().map(this::getUnconvertedPartitionKeyValue).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public KVStream<Entry> stream() {
        return new KVStream(new DynamoDBExecutor(this.readWriteLock));
    }

    @Override
    public void close() {
    }

    private class DynamoDBExecutor
    implements SecretEventStream.Executor<Entry> {
        private final ReadWriteLock readWriteLock;

        DynamoDBExecutor(ReadWriteLock readWriteLock) {
            this.readWriteLock = readWriteLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Stream<Entry> toJavaStream(SecretEventStream.Filter<Entry> filter) {
            this.readWriteLock.readLock().lock();
            try {
                Stream s = this.stream(filter);
                List<Object> copy = s.collect(Collectors.toList());
                if (filter.parsedKeyCondition.isPresent()) {
                    copy.forEach(entry -> {
                        if (!filter.parsedKeyCondition.get().evaluate(entry)) {
                            throw new PotentiallyMaliciousDataException("The data returned from the server does not match the search expression!");
                        }
                    });
                }
                if (filter.parsedAttributeCondition.isPresent()) {
                    copy.forEach(entry -> {
                        if (!filter.parsedAttributeCondition.get().evaluate(entry)) {
                            throw new PotentiallyMaliciousDataException("The data returned from the server does not match the search expression!");
                        }
                    });
                }
                Stream<Object> result = copy.stream();
                if (filter.unique) {
                    result = result.filter(this.distinctByKey(e -> GenericDynamoDB.this.getPartitionKeyValue(e)));
                }
                Stream stream = result;
                return stream;
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }

        private <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
            ConcurrentHashMap seen = new ConcurrentHashMap();
            return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
        }

        private Stream<Entry> stream(SecretEventStream.Filter<Entry> filter) {
            if (filter.parsedKeyCondition.isPresent()) {
                return this.query(filter);
            }
            if (filter.parsedAttributeCondition.isPresent()) {
                return this.scan(filter, GenericDynamoDB.this.converters);
            }
            return this.all();
        }

        private Stream<Entry> query(SecretEventStream.Filter<Entry> filter) {
            QueryRequest queryRequest = new QueryRequest();
            queryRequest.withTableName(GenericDynamoDB.this.tableName);
            queryRequest.withConsistentRead(Boolean.valueOf(true));
            if (filter.reverse) {
                queryRequest.setScanIndexForward(Boolean.valueOf(false));
            }
            KeyExpressionGenerator keyExpressionGenerator = new KeyExpressionGenerator();
            KeyExpressionGenerator.KeyCondition keyExpression = keyExpressionGenerator.process(filter.parsedKeyCondition.get(), GenericDynamoDB.this.converters);
            Map<String, String> expressionAttributeNames = keyExpression.expressionAttributeNames;
            Map<String, AttributeValue> expressionAttributeValues = keyExpression.expressionAttributeValues;
            if (filter.parsedAttributeCondition.isPresent()) {
                FilterGenerator filterGenerator = new FilterGenerator(expressionAttributeValues.size() + 1);
                FilterGenerator.Filter generated = filterGenerator.process(filter.parsedAttributeCondition.get(), GenericDynamoDB.this.converters);
                if (!generated.expressionAttributeNames.isEmpty()) {
                    expressionAttributeNames = FilterGenerator.merge(expressionAttributeNames, generated.expressionAttributeNames);
                }
                if (!generated.expressionAttributeValues.isEmpty()) {
                    expressionAttributeValues = FilterGenerator.merge(expressionAttributeValues, generated.expressionAttributeValues);
                }
                queryRequest.withFilterExpression(generated.filterExpression);
            }
            queryRequest.withExpressionAttributeNames(expressionAttributeNames);
            queryRequest.withExpressionAttributeValues(expressionAttributeValues);
            queryRequest.withKeyConditionExpression(keyExpression.keyConditionExpression);
            QueryResult result = GenericDynamoDB.this.client.query(queryRequest);
            ArrayList results = new ArrayList();
            results.addAll(result.getItems());
            while (result.getLastEvaluatedKey() != null) {
                queryRequest = queryRequest.withExclusiveStartKey(result.getLastEvaluatedKey());
                result = GenericDynamoDB.this.client.query(queryRequest);
                results.addAll(result.getItems());
            }
            return results.stream().map(this::fromMap);
        }

        private Stream<Entry> scan(SecretEventStream.Filter<Entry> filter, Converters converters) {
            ScanRequest scanRequest = new ScanRequest();
            scanRequest.withConsistentRead(Boolean.valueOf(true));
            scanRequest.withTableName(GenericDynamoDB.this.tableName);
            FilterGenerator filterGenerator = new FilterGenerator();
            FilterGenerator.Filter generated = filterGenerator.process(filter.parsedAttributeCondition.get(), converters);
            if (!generated.expressionAttributeNames.isEmpty()) {
                scanRequest.withExpressionAttributeNames(generated.expressionAttributeNames);
            }
            if (!generated.expressionAttributeValues.isEmpty()) {
                scanRequest.withExpressionAttributeValues(generated.expressionAttributeValues);
            }
            scanRequest.withFilterExpression(generated.filterExpression);
            ScanResult result = GenericDynamoDB.this.client.scan(scanRequest);
            ArrayList results = new ArrayList();
            results.addAll(result.getItems());
            while (result.getLastEvaluatedKey() != null) {
                scanRequest = scanRequest.withExclusiveStartKey(result.getLastEvaluatedKey());
                result = GenericDynamoDB.this.client.scan(scanRequest);
                results.addAll(result.getItems());
            }
            Stream<Object> typedResult = results.stream().map(this::fromMap);
            if (filter.reverse) {
                typedResult = Lists.reverse((List)typedResult.collect(Collectors.toCollection(LinkedList::new))).stream();
            }
            return typedResult;
        }

        private Stream<Entry> all() {
            ScanRequest scanRequest = new ScanRequest();
            scanRequest.withConsistentRead(Boolean.valueOf(true));
            scanRequest.withTableName(GenericDynamoDB.this.tableName);
            ScanResult result = GenericDynamoDB.this.client.scan(scanRequest);
            ArrayList results = new ArrayList();
            results.addAll(result.getItems());
            while (result.getLastEvaluatedKey() != null) {
                scanRequest = scanRequest.withExclusiveStartKey(result.getLastEvaluatedKey());
                result = GenericDynamoDB.this.client.scan(scanRequest);
                results.addAll(result.getItems());
            }
            return results.stream().map(this::fromMap);
        }

        private Entry fromMap(Map<String, AttributeValue> map) {
            String optimisticLock = "";
            try {
                Object result = GenericDynamoDB.this.clazz.newInstance();
                for (Map.Entry<String, AttributeValue> entry : map.entrySet()) {
                    if (entry.getKey().equals("0")) {
                        if (entry.getValue().getN().equals("1")) continue;
                        throw new IllegalArgumentException(String.format("Expected version %s got version %s", "1", entry.getValue().getS()));
                    }
                    if (entry.getKey().equals("optimisticLock")) {
                        optimisticLock = entry.getValue().getS();
                        continue;
                    }
                    String fieldName = GenericDynamoDB.this.getFieldName(entry.getKey());
                    try {
                        Object fieldValue;
                        Field field = GenericDynamoDB.this.clazz.getField(fieldName);
                        AttributeValue v = entry.getValue();
                        String value = this.getValueAsString(v);
                        if (field.getType().equals(Optional.class)) {
                            ParameterizedType type = (ParameterizedType)field.getGenericType();
                            Class unpackedFieldType = (Class)type.getActualTypeArguments()[0];
                            fieldValue = this.getFieldValue(value, unpackedFieldType, true);
                        } else {
                            fieldValue = this.getFieldValue(value, field.getType(), false);
                        }
                        field.set(result, fieldValue);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new FieldAccessException(fieldName, entry.getClass().getName(), e);
                    }
                }
                this.verify(result, optimisticLock);
                return result;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ParseException("Failed to instantiate class", e);
            }
        }

        void verify(Entry entry, String optimisticLock) {
            if (!GenericDynamoDB.this.sha(entry).equals(optimisticLock)) {
                throw new PotentiallyMaliciousDataException("The optimistic lock does not match the SHA1 of the encrypted payload");
            }
        }

        private Object getFieldValue(Object value, Class<?> type, boolean isOptional) {
            Object v;
            Class<?> clz = GenericDynamoDB.this.converters.getConvertedType(type);
            if (clz.equals(String.class)) {
                v = value;
            } else if (clz.equals(Long.class)) {
                v = Long.valueOf((String)value);
            } else if (clz.equals(Byte.class)) {
                v = Byte.valueOf((String)value);
            } else if (clz.equals(byte[].class)) {
                v = Encoder.base64decode((String)value);
            } else {
                throw new IllegalArgumentException(String.format("Unrecognized type '%s'", type.getName()));
            }
            if (isOptional) {
                return GenericDynamoDB.this.converters.fromOptionalObject(v, type);
            }
            return GenericDynamoDB.this.converters.fromObject(v, type);
        }

        private String getValueAsString(AttributeValue attributeValue) {
            if (attributeValue.getS() != null) {
                return attributeValue.getS();
            }
            if (attributeValue.getN() != null) {
                return attributeValue.getN();
            }
            throw new ParseException("Attribute value could not be extracted.");
        }
    }
}

