/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.kv4j.generic.backend.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.schibsted.security.strongbox.sdk.exceptions.UnsupportedTypeException;
import com.schibsted.security.strongbox.sdk.internal.converter.Converters;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.backend.dynamodb.FilterGenerator;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.RSEF;
import java.util.HashMap;
import java.util.Map;

public class KeyExpressionGenerator {
    public int count = 0;

    public <Entry> KeyCondition process(RSEF.ParsedKeyCondition<Entry> keyCondition, Converters converters) {
        if (keyCondition instanceof RSEF.KeyAND) {
            RSEF.KeyAND current = (RSEF.KeyAND)keyCondition;
            KeyCondition left = this.process(current.left, converters);
            KeyCondition right = this.process(current.right, converters);
            Map<String, String> expressionAttributeNames = FilterGenerator.merge(left.expressionAttributeNames, right.expressionAttributeNames);
            Map<String, AttributeValue> expressionAttributeValues = FilterGenerator.merge(left.expressionAttributeValues, right.expressionAttributeValues);
            String keyConditionExpression = String.format("(%s) AND (%s)", left.keyConditionExpression, right.keyConditionExpression);
            return new KeyCondition(expressionAttributeNames, expressionAttributeValues, keyConditionExpression);
        }
        if (keyCondition instanceof RSEF.PartitionKeyEqualityOperator) {
            RSEF.PartitionKeyEqualityOperator current = (RSEF.PartitionKeyEqualityOperator)keyCondition;
            KeyCondition left = this.createTerm(current.left, converters);
            KeyCondition right = this.createTerm(current.right, converters);
            Map<String, String> expressionAttributeNames = FilterGenerator.merge(left.expressionAttributeNames, right.expressionAttributeNames);
            Map<String, AttributeValue> expressionAttributeValues = FilterGenerator.merge(left.expressionAttributeValues, right.expressionAttributeValues);
            String keyConditionExpression = String.format("%s = %s", left.keyConditionExpression, right.keyConditionExpression);
            return new KeyCondition(expressionAttributeNames, expressionAttributeValues, keyConditionExpression);
        }
        if (keyCondition instanceof RSEF.SortKeyComparisonOperator) {
            RSEF.SortKeyComparisonOperator current = (RSEF.SortKeyComparisonOperator)keyCondition;
            KeyCondition left = this.createTerm(current.left, converters);
            KeyCondition right = this.createTerm(current.right, converters);
            Map<String, String> expressionAttributeNames = FilterGenerator.merge(left.expressionAttributeNames, right.expressionAttributeNames);
            Map<String, AttributeValue> expressionAttributeValues = FilterGenerator.merge(left.expressionAttributeValues, right.expressionAttributeValues);
            String keyConditionExpression = String.format("%s %s %s", left.keyConditionExpression, FilterGenerator.getOperator(current.binaryOpType), right.keyConditionExpression);
            return new KeyCondition(expressionAttributeNames, expressionAttributeValues, keyConditionExpression);
        }
        throw new UnsupportedTypeException(keyCondition.getClass().getName());
    }

    public <T> KeyCondition createTerm(RSEF.TypedTerm<T> typedTerm, Converters converters) {
        if (typedTerm instanceof RSEF.TypedPartitionKeyReference) {
            RSEF.TypedPartitionKeyReference current = (RSEF.TypedPartitionKeyReference)typedTerm;
            HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
            String paddedName = String.format("#%s", current.position.toString());
            expressionAttributeNames.put(paddedName, current.position.toString());
            return new KeyCondition(expressionAttributeNames, paddedName);
        }
        if (typedTerm instanceof RSEF.TypedSortKeyReference) {
            RSEF.TypedSortKeyReference current = (RSEF.TypedSortKeyReference)typedTerm;
            HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
            String paddedName = String.format("#%s", current.position.toString());
            expressionAttributeNames.put(paddedName, current.position.toString());
            return new KeyCondition(expressionAttributeNames, paddedName);
        }
        if (typedTerm instanceof RSEF.TypedLiteral) {
            RSEF.TypedLiteral current = (RSEF.TypedLiteral)typedTerm;
            String placeHolderName = String.format(":%s", FilterGenerator.convertNumberToLetters(this.count++));
            String value = converters.to(current.value);
            HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
            AttributeValue attributeValue = new AttributeValue();
            if (current.value instanceof Long) {
                attributeValue.setN(value);
            } else {
                attributeValue.setS(value);
            }
            expressionAttributeValues.put(placeHolderName, attributeValue);
            return new KeyCondition(placeHolderName, expressionAttributeValues);
        }
        throw new UnsupportedTypeException(typedTerm.getClass().getName());
    }

    public static class KeyCondition {
        public final Map<String, String> expressionAttributeNames;
        public final Map<String, AttributeValue> expressionAttributeValues;
        public final String keyConditionExpression;

        public KeyCondition(Map<String, String> expressionAttributeNames, Map<String, AttributeValue> expressionAttributeValues, String keyConditionExpression) {
            this.expressionAttributeNames = expressionAttributeNames;
            this.expressionAttributeValues = expressionAttributeValues;
            this.keyConditionExpression = keyConditionExpression;
        }

        public KeyCondition(Map<String, String> expressionAttributeNames, String keyConditionExpression) {
            this.expressionAttributeNames = expressionAttributeNames;
            this.expressionAttributeValues = new HashMap<String, AttributeValue>();
            this.keyConditionExpression = keyConditionExpression;
        }

        public KeyCondition(String keyConditionExpression, Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeNames = new HashMap<String, String>();
            this.expressionAttributeValues = expressionAttributeValues;
            this.keyConditionExpression = keyConditionExpression;
        }
    }
}

