/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend;

import com.schibsted.security.strongbox.sdk.internal.kv4j.generated.Config;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.KVStream;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.Parser;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.RSEF;
import com.schibsted.security.strongbox.sdk.types.RawSecretEntry;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;
import com.schibsted.security.strongbox.sdk.types.State;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SecretEventStream {
    void examples() {
        KVStream<RawSecretEntry> entryStream = new KVStream<RawSecretEntry>(new DummyExecutor());
        List entries = entryStream.filter(Config.name.eq(new SecretIdentifier("toByteArray"))).reverse().uniquePrimaryKey().toList();
        List entries2 = entryStream.filter(Config.name.eq(new SecretIdentifier("toByteArray"))).toList();
        List entries3 = entryStream.filter(Config.state.eq((State)((Object)Config.state)).AND(Config.notBefore.isNotPresent().OR(Config.notBefore.get().le((ZonedDateTime)((Object)Config.notBefore.get()))).AND(Config.notAfter.isNotPresent().OR(Config.notAfter.get().ge((ZonedDateTime)((Object)Config.notAfter.get())))))).toList();
        Optional entries4 = entryStream.filter(Config.name.eq(new SecretIdentifier("toByteArray"))).findFirst();
        List entries5 = entryStream.filter(Config.notAfter.get().eq((ZonedDateTime)((Object)Config.notAfter.get()))).uniquePrimaryKey().toList();
        entryStream.filter(RSEF.partitionKey.eq("toByteArray").AND(RSEF.sortKey.eq("1"))).filter(Config.state.eq(State.ENABLED)).toList();
        entryStream.filter(RSEF.partitionKey.eq("toByteArray").AND(RSEF.sortKey.eq("1"))).filter(Config.state.eq(State.ENABLED)).toList();
    }

    public static class EntryStreamKey<T>
    extends EntryStreamAttribute<T> {
        public EntryStreamKey(Executor<T> executor) {
            super(executor);
        }

        public EntryStreamAttribute<T> filter(RSEF.AttributeCondition condition) {
            this.attributeCondition = Optional.of(condition);
            return this;
        }
    }

    public static class EntryStreamAttribute<T>
    extends EntryStreamReverse<T> {
        public EntryStreamAttribute(Executor<T> executor) {
            super(executor);
        }

        public EntryStreamReverse<T> reverse() {
            this.reverse = true;
            return this;
        }
    }

    public static class EntryStreamReverse<T>
    extends EntryStreamUnique<T> {
        public EntryStreamReverse(Executor<T> executor) {
            super(executor);
        }

        public EntryStreamUnique<T> uniquePrimaryKey() {
            this.unique = true;
            return this;
        }
    }

    public static class EntryStreamUnique<S> {
        protected Optional<RSEF.KeyCondition> keyCondition = Optional.empty();
        protected Optional<RSEF.AttributeCondition> attributeCondition = Optional.empty();
        protected Optional<RSEF.ParsedAttributeCondition<S>> parsedAttributeCondition = Optional.empty();
        protected Optional<RSEF.ParsedKeyCondition<S>> parsedKeyCondition = Optional.empty();
        protected boolean reverse = false;
        protected boolean unique = false;
        private Executor<S> executor;

        public EntryStreamUnique(Executor<S> executor) {
            this.executor = executor;
        }

        public Stream<S> toJavaStream() {
            this.parse();
            return this.executor.toJavaStream(new Filter<S>(this.keyCondition, this.parsedKeyCondition, this.attributeCondition, this.parsedAttributeCondition, this.reverse, this.unique));
        }

        public List<S> toList() {
            return this.toJavaStream().collect(Collectors.toList());
        }

        public Optional<S> findFirst() {
            return this.toJavaStream().findFirst();
        }

        public void forEach(Consumer<? super S> action) {
            this.toJavaStream().forEach(action);
        }

        private void parse() {
            if (this.keyCondition.isPresent()) {
                this.parsedKeyCondition = Optional.of(Parser.createAST(this.keyCondition.get()));
            }
            if (this.attributeCondition.isPresent()) {
                this.parsedAttributeCondition = Optional.of(Parser.createAST(this.attributeCondition.get()));
            }
        }
    }

    public static class Filter<S> {
        public Optional<RSEF.KeyCondition> keyCondition;
        public Optional<RSEF.AttributeCondition> attributeFilter;
        public Optional<RSEF.ParsedAttributeCondition<S>> parsedAttributeCondition;
        public Optional<RSEF.ParsedKeyCondition<S>> parsedKeyCondition;
        public boolean reverse;
        public boolean unique;

        public Filter(Optional<RSEF.KeyCondition> keyCondition, Optional<RSEF.ParsedKeyCondition<S>> parsedKeyCondition, Optional<RSEF.AttributeCondition> attributeFilter, Optional<RSEF.ParsedAttributeCondition<S>> parsedAttributeCondition, boolean reverse, boolean unique) {
            this.keyCondition = keyCondition;
            this.parsedKeyCondition = parsedKeyCondition;
            this.attributeFilter = attributeFilter;
            this.parsedAttributeCondition = parsedAttributeCondition;
            this.reverse = reverse;
            this.unique = unique;
        }
    }

    public static class DummyExecutor
    implements Executor<RawSecretEntry> {
        @Override
        public Stream<RawSecretEntry> toJavaStream(Filter<RawSecretEntry> filter) {
            return null;
        }
    }

    public static interface Executor<T> {
        public Stream<T> toJavaStream(Filter<T> var1);
    }
}

