/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.types.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.schibsted.security.strongbox.sdk.exceptions.AlreadyExistsException;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class UserConfig {
    @JsonProperty(value="localFiles")
    protected final Map<SecretsGroupIdentifier, File> localFiles;

    protected void checkUniqueGroup(SecretsGroupIdentifier group) {
        if (this.localFiles.containsKey(group)) {
            throw new AlreadyExistsException(String.format("Group %s already found in user config ", group.name));
        }
    }

    protected void checkUniqueFilePath(File path) {
        if (this.localFiles.containsValue(path)) {
            throw new AlreadyExistsException(String.format("Path %s already found in user config", path.getAbsoluteFile()));
        }
    }

    public UserConfig(@JsonProperty(value="localFiles") Map<SecretsGroupIdentifier, File> localFiles) {
        this.localFiles = localFiles;
    }

    public UserConfig() {
        this.localFiles = new HashMap<SecretsGroupIdentifier, File>();
    }

    public Map<SecretsGroupIdentifier, File> getMap() {
        return this.localFiles;
    }

    public Optional<File> getLocalFilePath(SecretsGroupIdentifier group) {
        return Optional.ofNullable(this.localFiles.get(group));
    }

    public void addLocalFilePath(SecretsGroupIdentifier group, File path) {
        this.checkUniqueGroup(group);
        this.checkUniqueFilePath(path);
        this.localFiles.put(group, path);
    }

    public void updateLocalFilePath(SecretsGroupIdentifier group, File path) {
        this.checkUniqueFilePath(path);
        this.localFiles.put(group, path);
    }

    public void removeLocalFilePath(SecretsGroupIdentifier group) {
        this.localFiles.remove(group);
    }
}

