/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.types.SecretEntry;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;
import java.util.Arrays;

public class ByteSecretEntry {
    public final SecretIdentifier secretIdentifer;
    public final long version;
    public final byte[] value;

    public ByteSecretEntry(SecretIdentifier secretIdentifer, long version, byte[] value) {
        this.secretIdentifer = secretIdentifer;
        this.version = version;
        this.value = value;
    }

    public static ByteSecretEntry of(SecretEntry secretEntry) {
        return new ByteSecretEntry(secretEntry.secretIdentifier, secretEntry.version, secretEntry.secretValue.asByteArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteSecretEntry that = (ByteSecretEntry)o;
        return this.version == that.version && Objects.equal((Object)this.secretIdentifer, (Object)that.secretIdentifer) && Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.secretIdentifer, this.version, this.value});
    }
}

