/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.google.common.base.MoreObjects;
import com.schibsted.security.strongbox.sdk.internal.converter.Encoder;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShred;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShredder;
import java.util.Arrays;

public class Comment
implements BestEffortShred {
    public static final int MIN_LENGTH = 1;
    public static final int MAX_LENGTH = 1000;
    private byte[] comment;

    public Comment(String comment) {
        this(Encoder.asUTF8(comment));
    }

    public Comment(byte[] comment) {
        if (comment.length < 1) {
            throw new IllegalArgumentException(String.format("The comment must be at least %d characters long", 1));
        }
        if (comment.length > 1000) {
            throw new IllegalArgumentException(String.format("The comment cannot be longer than %d characters long", 1000));
        }
        this.comment = comment;
    }

    public byte[] asByteArray() {
        return this.comment;
    }

    public String asString() {
        return Encoder.fromUTF8(this.comment);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.comment);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Comment) {
            Comment other = (Comment)obj;
            return Arrays.equals(this.comment, other.asByteArray());
        }
        return false;
    }

    @Override
    public void bestEffortShred() {
        BestEffortShredder.shred(this.comment);
    }
}

