/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.Map;

public enum PrincipalType {
    GROUP("group"),
    USER("user"),
    ROLE("role");

    public String name;
    private static Map<String, PrincipalType> typeMap;

    private PrincipalType(String name) {
        this.name = name;
    }

    public static PrincipalType fromString(String principalType) {
        PrincipalType type = typeMap.get(principalType);
        if (type == null) {
            throw new IllegalArgumentException(String.format("Unrecognized PrincipalType '%s', expected one of {%s}", principalType, Joiner.on((String)", ").join(typeMap.keySet())));
        }
        return type;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    static {
        typeMap = new HashMap<String, PrincipalType>();
        for (PrincipalType type : PrincipalType.values()) {
            typeMap.put(type.name, type);
        }
    }
}

